/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.tasks.player.TeleportTask;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;

public class L2JailZone
extends L2ZoneType {
    private static final Location JAIL_IN_LOC = new Location(-114356, -249645, -2984);
    private static final Location JAIL_OUT_LOC = new Location(17836, 170178, -3507);

    public L2JailZone(int id) {
        super(id);
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.JAIL, true);
            character.setInsideZone(ZoneId.NO_SUMMON_FRIEND, true);
            if (Configuration.general().jailIsPvp()) {
                character.setInsideZone(ZoneId.PVP, true);
                character.sendPacket(SystemMessageId.ENTERED_COMBAT_ZONE);
            }
            if (Configuration.general().jailDisableTransaction()) {
                character.setInsideZone(ZoneId.NO_STORE, true);
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isPlayer()) {
            L2PcInstance player = character.getActingPlayer();
            player.setInsideZone(ZoneId.JAIL, false);
            player.setInsideZone(ZoneId.NO_SUMMON_FRIEND, false);
            if (Configuration.general().jailIsPvp()) {
                character.setInsideZone(ZoneId.PVP, false);
                character.sendPacket(SystemMessageId.LEFT_COMBAT_ZONE);
            }
            if (player.isJailed()) {
                ThreadPoolManager.getInstance().scheduleGeneral(new TeleportTask(player, JAIL_IN_LOC), 2000L);
                character.sendMessage("You cannot cheat your way out of here. You must wait until your jail time is over.");
            }
            if (Configuration.general().jailDisableTransaction()) {
                character.setInsideZone(ZoneId.NO_STORE, false);
            }
        }
    }

    public static Location getLocationIn() {
        return JAIL_IN_LOC;
    }

    public static Location getLocationOut() {
        return JAIL_OUT_LOC;
    }
}

