/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;

public class L2NoLandingZone
extends L2ZoneType {
    private int dismountDelay = 5;

    public L2NoLandingZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("dismountDelay")) {
            this.dismountDelay = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.NO_LANDING, true);
            if (character.getActingPlayer().getMountType() == MountType.WYVERN) {
                character.sendPacket(SystemMessageId.AREA_CANNOT_BE_ENTERED_WHILE_MOUNTED_WYVERN);
                character.getActingPlayer().enteredNoLanding(this.dismountDelay);
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.NO_LANDING, false);
            if (character.getActingPlayer().getMountType() == MountType.WYVERN) {
                character.getActingPlayer().exitedNoLanding();
            }
        }
    }
}

