/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;

public class L2PeaceZone
extends L2ZoneType {
    public L2PeaceZone(int id) {
        super(id);
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character.isPlayer()) {
            L2PcInstance player = character.getActingPlayer();
            if (player.isCombatFlagEquipped() && TerritoryWarManager.getInstance().isTWInProgress()) {
                TerritoryWarManager.getInstance().dropCombatFlag(player, false, true);
            }
            if (player.getSiegeState() != 0 && Configuration.general().getPeaceZoneMode() == 1) {
                return;
            }
            player.getHuntingSystem().stopHuntingBonusTask(true);
            player.getRecSystem().stopBonusTask(true);
        }
        if (Configuration.general().getPeaceZoneMode() != 2) {
            character.setInsideZone(ZoneId.PEACE, true);
        }
        if (!this.getAllowStore()) {
            character.setInsideZone(ZoneId.NO_STORE, true);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (Configuration.general().getPeaceZoneMode() != 2) {
            character.setInsideZone(ZoneId.PEACE, false);
        }
        if (!this.getAllowStore()) {
            character.setInsideZone(ZoneId.NO_STORE, false);
        }
    }
}

