/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.data.xml.impl.SecondaryAuthData;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.BlowFishKeygen;
import com.l2jserver.gameserver.network.ClientStats;
import com.l2jserver.gameserver.network.GameCrypt;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import com.l2jserver.gameserver.security.SecondaryPasswordAuth;
import com.l2jserver.gameserver.util.FloodProtectors;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.mmocore.MMOClient;
import com.l2jserver.mmocore.MMOConnection;
import com.l2jserver.mmocore.ReceivablePacket;
import com.l2jserver.mmocore.SendablePacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class L2GameClient
extends MMOClient<MMOConnection<L2GameClient>>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(L2GameClient.class);
    private static final Logger LOG_ACCOUNTING = LoggerFactory.getLogger("accounting");
    private static final Logger LOG_AUDIT = LoggerFactory.getLogger("audit");
    private GameClientState _state;
    private final InetAddress _addr;
    private String _accountName;
    private LoginServerThread.SessionKey _sessionId;
    private L2PcInstance _activeChar;
    private final ReentrantLock _activeCharLock = new ReentrantLock();
    private SecondaryPasswordAuth _secondaryAuth;
    private boolean _isAuthedGG;
    private final long _connectionStartTime;
    private List<CharSelectInfoPackage> _charSlotMapping = null;
    private int _charSlot = -1;
    private final FloodProtectors _floodProtectors = new FloodProtectors(this);
    protected final ScheduledFuture<?> _autoSaveInDB;
    protected ScheduledFuture<?> _cleanupTask = null;
    private L2GameServerPacket _additionalClosePacket;
    private final GameCrypt _crypt;
    private final ClientStats _stats;
    private boolean _isDetached = false;
    private boolean _protocol;
    private final ArrayBlockingQueue<ReceivablePacket<L2GameClient>> _packetQueue;
    private final ReentrantLock _queueLock = new ReentrantLock();
    private int[][] trace;

    public L2GameClient(MMOConnection<L2GameClient> con) {
        super(con);
        this._state = GameClientState.CONNECTED;
        this._connectionStartTime = System.currentTimeMillis();
        this._crypt = new GameCrypt();
        this._stats = new ClientStats();
        int capacity = Math.max(Configuration.general().getClientPacketQueueSize(), Configuration.mmo().getMaxReadPerPass() + 2);
        this._packetQueue = new ArrayBlockingQueue(capacity);
        this._autoSaveInDB = Configuration.general().getCharacterDataStoreInterval() > 0L ? ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new AutoSaveTask(), 300000L, Configuration.general().getCharacterDataStoreInterval()) : null;
        try {
            this._addr = con != null ? con.getInetAddress() : InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new Error("Unable to determine localhost address.");
        }
    }

    public byte[] enableCrypt() {
        byte[] key = BlowFishKeygen.getRandomKey();
        this._crypt.setKey(key);
        return key;
    }

    public GameClientState getState() {
        return this._state;
    }

    public void setState(GameClientState pState) {
        if (this._state != pState) {
            this._state = pState;
            this._packetQueue.clear();
        }
    }

    public ClientStats getStats() {
        return this._stats;
    }

    public InetAddress getConnectionAddress() {
        return this._addr;
    }

    public long getConnectionStartTime() {
        return this._connectionStartTime;
    }

    public boolean decrypt(ByteBuffer buf, int size) {
        this._crypt.decrypt(buf.array(), buf.position(), size);
        return true;
    }

    public boolean encrypt(ByteBuffer buf, int size) {
        this._crypt.encrypt(buf.array(), buf.position(), size);
        buf.position(buf.position() + size);
        return true;
    }

    public L2PcInstance getActiveChar() {
        return this._activeChar;
    }

    public void setActiveChar(L2PcInstance pActiveChar) {
        this._activeChar = pActiveChar;
    }

    public ReentrantLock getActiveCharLock() {
        return this._activeCharLock;
    }

    public FloodProtectors getFloodProtectors() {
        return this._floodProtectors;
    }

    public void setGameGuardOk(boolean val) {
        this._isAuthedGG = val;
    }

    public boolean isAuthedGG() {
        return this._isAuthedGG;
    }

    public void setAccountName(String pAccountName) {
        this._accountName = pAccountName;
        if (SecondaryAuthData.getInstance().isEnabled()) {
            this._secondaryAuth = new SecondaryPasswordAuth(this);
        }
    }

    public String getAccountName() {
        return this._accountName;
    }

    public void setSessionId(LoginServerThread.SessionKey sk) {
        this._sessionId = sk;
    }

    public LoginServerThread.SessionKey getSessionId() {
        return this._sessionId;
    }

    public void sendPacket(L2GameServerPacket gsp) {
        if (this._isDetached || gsp == null) {
            return;
        }
        if (gsp.isInvisible() && this.getActiveChar() != null && !this.getActiveChar().canOverrideCond(PcCondOverride.SEE_ALL_PLAYERS)) {
            return;
        }
        this.getConnection().sendPacket((SendablePacket)gsp);
        gsp.runImpl();
    }

    public boolean isDetached() {
        return this._isDetached;
    }

    public void setDetached(boolean b) {
        this._isDetached = b;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte markToDeleteChar(int charslot) {
        int objid = this.getObjectIdForSlot(charslot);
        if (objid < 0) {
            return -1;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            byte by;
            block32: {
                PreparedStatement ps = con.prepareStatement("SELECT clanId FROM characters WHERE charId=?");
                try {
                    byte answer;
                    block30: {
                        ps.setInt(1, objid);
                        answer = 0;
                        try (ResultSet rs = ps.executeQuery();){
                            int clanId;
                            int n = clanId = rs.next() ? rs.getInt(1) : 0;
                            if (clanId != 0) {
                                L2Clan clan = ClanTable.getInstance().getClan(clanId);
                                answer = clan == null ? (byte)0 : (clan.getLeaderId() == objid ? (byte)2 : 1);
                            }
                            if (answer != 0) break block30;
                            if (Configuration.character().getDeleteCharAfterDays() == 0) {
                                L2GameClient.deleteCharByObjId(objid);
                            } else {
                                try (PreparedStatement ps2 = con.prepareStatement("UPDATE characters SET deletetime=? WHERE charId=?");){
                                    ps2.setLong(1, System.currentTimeMillis() + TimeUnit.DAYS.toMillis(Configuration.character().getDeleteCharAfterDays()));
                                    ps2.setInt(2, objid);
                                    ps2.execute();
                                }
                            }
                            LOG_ACCOUNTING.info("Deleted character Id {} and client {}.", (Object)objid, (Object)this);
                        }
                    }
                    by = answer;
                    if (ps == null) break block32;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return by;
        }
        catch (Exception ex) {
            LOG.error("There has been an error updating delete time of character!", ex);
            return -1;
        }
    }

    public void saveCharToDisk() {
        try {
            if (this.getActiveChar() != null) {
                this.getActiveChar().storeMe();
                this.getActiveChar().getRecSystem().store();
                if (Configuration.general().updateItemsOnCharStore()) {
                    this.getActiveChar().getInventory().updateDatabase();
                    this.getActiveChar().getWarehouse().updateDatabase();
                }
            }
        }
        catch (Exception ex) {
            LOG.error("There has been an error saving character!", ex);
        }
    }

    public void markRestoredChar(int charslot) {
        int objid = this.getObjectIdForSlot(charslot);
        if (objid < 0) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("UPDATE characters SET deletetime=0 WHERE charId=?");){
            ps.setInt(1, objid);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("There has been an error restoring character!", ex);
        }
        LOG_ACCOUNTING.info("Restoring Character Id {}, client {}.", (Object)objid, (Object)this);
    }

    public static void deleteCharByObjId(int objid) {
        block176: {
            if (objid < 0) {
                return;
            }
            CharNameTable.getInstance().removeName(objid);
            try (Connection con = ConnectionFactory.getInstance().getConnection();){
                try (PreparedStatement ps = con.prepareStatement("DELETE FROM character_contacts WHERE charId=? OR contactId=?");){
                    ps.setInt(1, objid);
                    ps.setInt(2, objid);
                    ps.execute();
                }
                ps = con.prepareStatement("DELETE FROM character_friends WHERE charId=? OR friendId=?");
                try {
                    ps.setInt(1, objid);
                    ps.setInt(2, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_hennas WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_macroses WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_quests WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_quest_global_data WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_recipebook WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_shortcuts WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_skills WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_skills_save WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_subclasses WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM heroes WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM olympiad_nobles WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM seven_signs WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM pets WHERE item_obj_id IN (SELECT object_id FROM items WHERE items.owner_id=?)");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM item_attributes WHERE itemId IN (SELECT object_id FROM items WHERE items.owner_id=?)");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM items WHERE owner_id=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM merchant_lease WHERE player_id=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_raid_points WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_reco_bonus WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_instance_time WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM character_variables WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                ps = con.prepareStatement("DELETE FROM characters WHERE charId=?");
                try {
                    ps.setInt(1, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                if (!Configuration.customs().allowWedding()) break block176;
                ps = con.prepareStatement("DELETE FROM mods_wedding WHERE player1Id = ? OR player2Id = ?");
                try {
                    ps.setInt(1, objid);
                    ps.setInt(2, objid);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn("There has been an error deleting character Id {}!", (Object)objid, (Object)ex);
            }
        }
    }

    public L2PcInstance loadCharFromDisk(int charslot) {
        int objId = this.getObjectIdForSlot(charslot);
        if (objId < 0) {
            return null;
        }
        L2PcInstance character = L2World.getInstance().getPlayer(objId);
        if (character != null) {
            LOG.error("Attempt of double login {}, account {}!", (Object)character, (Object)this.getAccountName());
            if (character.getClient() != null) {
                character.getClient().closeNow();
            } else {
                character.deleteMe();
            }
            return null;
        }
        character = L2PcInstance.load(objId);
        if (character != null) {
            character.setRunning();
            character.standUp();
            character.refreshOverloaded();
            character.refreshExpertisePenalty();
            character.setOnlineStatus(true, false);
        } else {
            LOG.error("Could not restore in slot {}!", (Object)charslot);
        }
        return character;
    }

    public void setCharSelection(List<CharSelectInfoPackage> list) {
        this._charSlotMapping = list;
    }

    public void setCharSelectionSlot(int charSlot) {
        this._charSlot = charSlot;
    }

    public CharSelectInfoPackage getCharSelection() {
        return this.getCharSelection(this._charSlot);
    }

    public CharSelectInfoPackage getCharSelection(int charslot) {
        if (this._charSlotMapping == null || charslot < 0 || charslot >= this._charSlotMapping.size()) {
            return null;
        }
        return this._charSlotMapping.get(charslot);
    }

    public SecondaryPasswordAuth getSecondaryAuth() {
        return this._secondaryAuth;
    }

    public void close(L2GameServerPacket gsp) {
        if (this.getConnection() == null) {
            return;
        }
        if (this._additionalClosePacket != null) {
            this.getConnection().close((SendablePacket[])new L2GameServerPacket[]{this._additionalClosePacket, gsp});
        } else {
            this.getConnection().close((SendablePacket)gsp);
        }
    }

    public void close(L2GameServerPacket[] gspArray) {
        if (this.getConnection() == null) {
            return;
        }
        this.getConnection().close((SendablePacket[])gspArray);
    }

    private int getObjectIdForSlot(int charSlot) {
        CharSelectInfoPackage info = this.getCharSelection(charSlot);
        if (info == null) {
            LOG.warn("{} tried to delete character in slot {} but no characters exits at that slot!", (Object)this, (Object)charSlot);
            return -1;
        }
        return info.getObjectId();
    }

    protected void onForcedDisconnection() {
        LOG_ACCOUNTING.warn("Client {} disconnected abnormally!", (Object)this);
    }

    protected void onDisconnection() {
        try {
            ThreadPoolManager.getInstance().executeGeneral(new DisconnectTask(this));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeNow() {
        this._isDetached = true;
        this.close(ServerClose.STATIC_PACKET);
        L2GameClient l2GameClient = this;
        synchronized (l2GameClient) {
            if (this._cleanupTask != null) {
                this.cancelCleanup();
            }
            this._cleanupTask = ThreadPoolManager.getInstance().scheduleGeneral(new CleanupTask(), 0L);
        }
    }

    public String toString() {
        try {
            InetAddress address = this.getConnection().getInetAddress();
            return switch (this.getState().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "[IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
                case 1 -> "[Account: " + this.getAccountName() + " - IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
                case 2, 3 -> "[Character: " + (String)(this.getActiveChar() == null ? "disconnected" : this.getActiveChar().getName() + "[" + this.getActiveChar().getObjectId() + "]") + " - Account: " + this.getAccountName() + " - IP: " + (address == null ? "disconnected" : address.getHostAddress()) + "]";
            };
        }
        catch (NullPointerException e) {
            return "[Character read failed due to disconnect]";
        }
    }

    protected boolean offlineMode(L2PcInstance player) {
        boolean canSetShop;
        if (player.isInOlympiadMode() || player.isFestivalParticipant() || player.isBlockedFromExit() || player.isJailed() || player.getVehicle() != null) {
            return false;
        }
        switch (player.getPrivateStoreType()) {
            case SELL: 
            case PACKAGE_SELL: 
            case BUY: {
                boolean bl = Configuration.customs().offlineTradeEnable();
                break;
            }
            case MANUFACTURE: {
                boolean bl = Configuration.customs().offlineTradeEnable();
                break;
            }
            default: {
                boolean bl = canSetShop = Configuration.customs().offlineCraftEnable() && player.isInCraftMode();
            }
        }
        if (Configuration.customs().offlineModeInPeaceZone() && !player.isInsideZone(ZoneId.PEACE)) {
            canSetShop = false;
        }
        return canSetShop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanMe(boolean fast) {
        try {
            L2GameClient l2GameClient = this;
            synchronized (l2GameClient) {
                if (this._cleanupTask == null) {
                    this._cleanupTask = ThreadPoolManager.getInstance().scheduleGeneral(new CleanupTask(), fast ? 5L : 15000L);
                }
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error during cleanup!", ex);
        }
    }

    public boolean isProtocolOk() {
        return this._protocol;
    }

    public void setProtocolOk(boolean b) {
        this._protocol = b;
    }

    public boolean handleCheat(String punishment) {
        if (this._activeChar != null) {
            Util.handleIllegalPlayerAction(this._activeChar, this.toString() + ": " + punishment);
            return true;
        }
        LOG_AUDIT.warn("Client {} kicked for {}!", (Object)this, (Object)punishment);
        this.closeNow();
        return false;
    }

    public boolean dropPacket() {
        if (this._isDetached) {
            return true;
        }
        if (this.getStats().countPacket(this._packetQueue.size())) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return true;
        }
        return this.getStats().dropPacket();
    }

    public void onBufferUnderflow() {
        if (this.getStats().countUnderflowException()) {
            LOG.error("Client {} disconnected, too many buffer underflow exceptions!", (Object)this);
            this.closeNow();
            return;
        }
        if (this._state == GameClientState.CONNECTED) {
            if (Configuration.general().packetHandlerDebug()) {
                LOG.error("Client {} disconnected, too many buffer underflow in non-authed state!", (Object)this);
            }
            this.closeNow();
        }
    }

    public void onUnknownPacket() {
        if (this.getStats().countUnknownPacket()) {
            LOG.error("Client {} disconnected, too many unknown packets!", (Object)this);
            this.closeNow();
            return;
        }
        if (this._state == GameClientState.CONNECTED) {
            if (Configuration.general().packetHandlerDebug()) {
                LOG.error("Client {} disconnected, too many unknown packets in non-authed state!", (Object)this);
            }
            this.closeNow();
        }
    }

    public void execute(ReceivablePacket<L2GameClient> packet) {
        block11: {
            if (this.getStats().countFloods()) {
                LOG.error("Client {} disconnected, too many floods {} long and {} short!", this, this.getStats().longFloods, this.getStats().shortFloods);
                this.closeNow();
                return;
            }
            if (!this._packetQueue.offer(packet)) {
                if (this.getStats().countQueueOverflow()) {
                    LOG.error("Client {} disconnected, too many queue overflows!", (Object)this);
                    this.closeNow();
                } else {
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                }
                return;
            }
            if (this._queueLock.isLocked()) {
                return;
            }
            try {
                if (this._state == GameClientState.CONNECTED) {
                    if (this.getStats().processedPackets > 3) {
                        if (Configuration.general().packetHandlerDebug()) {
                            LOG.error("Client {} disconnected, too many packets in non-authed state!", (Object)this);
                        }
                        this.closeNow();
                        return;
                    }
                    ThreadPoolManager.getInstance().executeIOPacket(this);
                } else {
                    ThreadPoolManager.getInstance().executePacket(this);
                }
            }
            catch (RejectedExecutionException ex) {
                if (ThreadPoolManager.getInstance().isShutdown()) break block11;
                LOG.error("Failed executing {}, for client {}!", packet.getClass().getSimpleName(), this.toString(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this._queueLock.tryLock()) {
            return;
        }
        try {
            int count = 0;
            do {
                ReceivablePacket<L2GameClient> packet;
                if ((packet = this._packetQueue.poll()) == null) {
                    return;
                }
                if (this._isDetached) {
                    this._packetQueue.clear();
                    return;
                }
                try {
                    packet.run();
                }
                catch (Exception ex) {
                    LOG.error("Exception during execution {}, client {}!", packet.getClass().getSimpleName(), this, ex);
                }
            } while (!this.getStats().countBurst(++count));
            return;
        }
        finally {
            this._queueLock.unlock();
        }
    }

    public void setClientTracert(int[][] tracert) {
        this.trace = tracert;
    }

    public int[][] getTrace() {
        return this.trace;
    }

    private boolean cancelCleanup() {
        ScheduledFuture<?> task = this._cleanupTask;
        if (task != null) {
            this._cleanupTask = null;
            return task.cancel(true);
        }
        return false;
    }

    public void setAdditionalClosePacket(L2GameServerPacket additionalClosePacket) {
        this._additionalClosePacket = additionalClosePacket;
    }

    public static enum GameClientState {
        CONNECTED,
        AUTHED,
        JOINING,
        IN_GAME;

    }

    protected class AutoSaveTask
    implements Runnable {
        protected AutoSaveTask() {
        }

        @Override
        public void run() {
            try {
                L2PcInstance player = L2GameClient.this.getActiveChar();
                if (player != null && player.isOnline()) {
                    L2GameClient.this.saveCharToDisk();
                    if (player.hasSummon()) {
                        player.getSummon().storeMe();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("There has been an error on AutoSaveTask!", ex);
            }
        }
    }

    protected class DisconnectTask
    implements Runnable {
        private final L2GameClient client;

        public DisconnectTask(L2GameClient client) {
            this.client = client;
        }

        @Override
        public void run() {
            boolean fast = true;
            try {
                L2PcInstance player = this.client.getActiveChar();
                if (player != null && !L2GameClient.this.isDetached()) {
                    L2GameClient.this.setDetached(true);
                    if (L2GameClient.this.offlineMode(player)) {
                        player.leaveParty();
                        OlympiadManager.getInstance().unRegisterNoble(player);
                        if (player.hasSummon()) {
                            player.getSummon().setRestoreSummon(true);
                            player.getSummon().unSummon(player);
                            if (player.getSummon() != null) {
                                player.getSummon().broadcastNpcInfo(0);
                            }
                        }
                        if (Configuration.customs().offlineSetNameColor()) {
                            player.getAppearance().setNameColor(Configuration.customs().getOfflineNameColor());
                            player.broadcastUserInfo();
                        }
                        if (player.getOfflineStartTime() == 0L) {
                            player.setOfflineStartTime(System.currentTimeMillis());
                        }
                        LOG_ACCOUNTING.info("Client {} entering offline mode.", (Object)this.client);
                        return;
                    }
                    fast = !player.isInCombat() && !player.isLocked();
                }
                L2GameClient.this.cleanMe(fast);
            }
            catch (Exception ex) {
                LOG.warn("There has been an error while disconnecting client {}!", (Object)this.client, (Object)ex);
            }
        }
    }

    protected class CleanupTask
    implements Runnable {
        protected CleanupTask() {
        }

        @Override
        public void run() {
            try {
                if (L2GameClient.this._autoSaveInDB != null) {
                    L2GameClient.this._autoSaveInDB.cancel(true);
                }
                if (L2GameClient.this.getActiveChar() != null) {
                    if (L2GameClient.this.getActiveChar().isLocked()) {
                        LOG.warn("Player {} still performing subclass actions during disconnect!", (Object)L2GameClient.this.getActiveChar());
                    }
                    if (L2Event.isParticipant(L2GameClient.this.getActiveChar())) {
                        L2Event.savePlayerEventStatus(L2GameClient.this.getActiveChar());
                    }
                    L2GameClient.this.getActiveChar().setClient(null);
                    if (L2GameClient.this.getActiveChar().isOnline()) {
                        L2GameClient.this.getActiveChar().deleteMe();
                        AntiFeedManager.getInstance().onDisconnect(L2GameClient.this);
                    }
                }
                L2GameClient.this.setActiveChar(null);
            }
            catch (Exception ex) {
                LOG.warn("There has been  an error while cleanup client!", ex);
            }
            finally {
                LoginServerThread.getInstance().sendLogout(L2GameClient.this.getAccountName());
            }
        }
    }
}

