/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TradeDone;

public final class AnswerTradeRequest
extends L2GameClientPacket {
    private static final String _C__55_ANSWERTRADEREQUEST = "[C] 55 AnswerTradeRequest";
    private int _response;

    @Override
    protected void readImpl() {
        this._response = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2PcInstance partner = player.getActiveRequester();
        if (partner == null) {
            player.sendPacket(new TradeDone(0));
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME));
            player.setActiveRequester(null);
            return;
        }
        if (L2World.getInstance().getPlayer(partner.getObjectId()) == null) {
            player.sendPacket(new TradeDone(0));
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME));
            player.setActiveRequester(null);
            return;
        }
        if (this._response == 1 && !partner.isRequestExpired()) {
            player.startTrade(partner);
        } else {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_DENIED_TRADE_REQUEST);
            msg.addString(player.getName());
            partner.sendPacket(msg);
        }
        player.setActiveRequester(null);
        partner.onTransactionResponse();
    }

    @Override
    public String getType() {
        return _C__55_ANSWERTRADEREQUEST;
    }
}

