/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;

public final class Attack
extends L2GameClientPacket {
    private static final String _C__01_ATTACK = "[C] 01 Attack";
    private int _objectId;
    private int _originX;
    private int _originY;
    private int _originZ;
    private int _attackId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._originX = this.readD();
        this._originY = this.readD();
        this._originZ = this.readD();
        this._attackId = this.readC();
    }

    @Override
    protected void runImpl() {
        L2Object target;
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isPlayable() && activeChar.isInBoat()) {
            activeChar.sendPacket(SystemMessageId.NOT_ALLOWED_ON_BOAT);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        BuffInfo info = activeChar.getEffectList().getBuffInfoByAbnormalType(AbnormalType.BOT_PENALTY);
        if (info != null) {
            for (AbstractEffect effect : info.getEffects()) {
                if (effect.checkCondition(-1)) continue;
                activeChar.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REPORTED_SO_ACTIONS_NOT_ALLOWED);
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        if ((target = activeChar.getTargetId() == this._objectId ? activeChar.getTarget() : L2World.getInstance().findObject(this._objectId)) == null) {
            return;
        }
        if (!target.isTargetable() && !activeChar.canOverrideCond(PcCondOverride.TARGET_ALL)) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (target.getInstanceId() != activeChar.getInstanceId() && activeChar.getInstanceId() != -1) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!target.isVisibleFor(activeChar)) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.getTarget() != target) {
            target.onAction(activeChar);
        } else if (target.getObjectId() != activeChar.getObjectId() && activeChar.getPrivateStoreType() == PrivateStoreType.NONE && activeChar.getActiveRequester() == null) {
            target.onForcedAttack(activeChar);
        } else {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    @Override
    public String getType() {
        return _C__01_ATTACK;
    }
}

