/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.data.xml.impl.SecondaryAuthData;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.model.CharSelectInfoPackage;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.Containers;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerSelect;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharSelected;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SSQInfo;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterSelect
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(CharacterSelect.class);
    private static final String _C__12_CHARACTERSELECT = "[C] 12 CharacterSelect";
    private static final Logger LOG_ACCOUNTING = LoggerFactory.getLogger("accounting");
    private int _charSlot;
    private int _unk1;
    private int _unk2;
    private int _unk3;
    private int _unk4;

    @Override
    protected void readImpl() {
        this._charSlot = this.readD();
        this._unk1 = this.readH();
        this._unk2 = this.readD();
        this._unk3 = this.readD();
        this._unk4 = this.readD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2GameClient client = (L2GameClient)this.getClient();
        if (!client.getFloodProtectors().getCharacterSelect().tryPerformAction("CharacterSelect")) {
            return;
        }
        if (SecondaryAuthData.getInstance().isEnabled() && !client.getSecondaryAuth().isAuthed()) {
            client.getSecondaryAuth().openDialog();
            return;
        }
        if (client.getActiveCharLock().tryLock()) {
            try {
                if (client.getActiveChar() == null) {
                    L2PcInstance cha;
                    CharSelectInfoPackage info = client.getCharSelection(this._charSlot);
                    if (info == null) {
                        return;
                    }
                    if (PunishmentManager.getInstance().hasPunishment(info.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.BAN) || PunishmentManager.getInstance().hasPunishment(client.getAccountName(), PunishmentAffect.ACCOUNT, PunishmentType.BAN) || PunishmentManager.getInstance().hasPunishment(client.getConnectionAddress().getHostAddress(), PunishmentAffect.IP, PunishmentType.BAN)) {
                        client.close(ServerClose.STATIC_PACKET);
                        return;
                    }
                    if (info.getAccessLevel() < 0) {
                        client.close(ServerClose.STATIC_PACKET);
                        return;
                    }
                    if (Configuration.customs().getDualboxCheckMaxPlayersPerIP() > 0 && !AntiFeedManager.getInstance().tryAddClient(0, client, Configuration.customs().getDualboxCheckMaxPlayersPerIP())) {
                        NpcHtmlMessage msg = new NpcHtmlMessage();
                        msg.setFile(info.getHtmlPrefix(), "data/html/mods/IPRestriction.htm");
                        msg.replace("%max%", String.valueOf(AntiFeedManager.getInstance().getLimit(client, Configuration.customs().getDualboxCheckMaxPlayersPerIP())));
                        client.sendPacket(msg);
                        return;
                    }
                    if (Configuration.general().debug()) {
                        LOG.debug("Selected slot: {}", (Object)this._charSlot);
                    }
                    if ((cha = client.loadCharFromDisk(this._charSlot)) == null) {
                        return;
                    }
                    L2World.getInstance().addPlayerToWorld(cha);
                    CharNameTable.getInstance().addName(cha);
                    cha.setClient(client);
                    client.setActiveChar(cha);
                    cha.setOnlineStatus(true, true);
                    TerminateReturn terminate = EventDispatcher.getInstance().notifyEvent(new PlayerSelect(cha, cha.getObjectId(), cha.getName(), (L2GameClient)this.getClient()), Containers.Players(), TerminateReturn.class);
                    if (terminate != null && terminate.terminate()) {
                        cha.deleteMe();
                        return;
                    }
                    client.setCharSelectionSlot(this._charSlot);
                    cha.restoreStatusFromLoadedValues();
                    this.sendPacket(new SSQInfo());
                    client.setState(L2GameClient.GameClientState.JOINING);
                    CharSelected cs = new CharSelected(cha, client.getSessionId().playOkID1);
                    this.sendPacket(cs);
                }
            }
            finally {
                client.getActiveCharLock().unlock();
            }
            LOG_ACCOUNTING.info("Client {} logged in.", (Object)client);
        }
    }

    @Override
    public String getType() {
        return _C__12_CHARACTERSELECT;
    }
}

