/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.custom.AutoLootExtension;
import com.l2jserver.gameserver.data.sql.impl.AnnouncementsTable;
import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.instancemanager.PetitionManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Couple;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.Die;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.network.serverpackets.ExGetBookMarkInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExNoticePostArrived;
import com.l2jserver.gameserver.network.serverpackets.ExNotifyPremiumItem;
import com.l2jserver.gameserver.network.serverpackets.ExShowContactList;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.ExUISetting;
import com.l2jserver.gameserver.network.serverpackets.ExVoteSystemInfo;
import com.l2jserver.gameserver.network.serverpackets.FriendList;
import com.l2jserver.gameserver.network.serverpackets.HennaInfo;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.PledgeStatusChanged;
import com.l2jserver.gameserver.network.serverpackets.QuestList;
import com.l2jserver.gameserver.network.serverpackets.ShortCutInit;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.Base64;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterWorld
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(EnterWorld.class);
    private static final String _C__11_ENTERWORLD = "[C] 11 EnterWorld";
    private static final double MIN_HP = 0.5;
    private static final int COMBAT_FLAG = 9819;
    private final int[][] tracert = new int[5][4];

    @Override
    protected void readImpl() {
        this.readB(new byte[32]);
        this.readD();
        this.readD();
        this.readD();
        this.readD();
        this.readB(new byte[32]);
        this.readD();
        for (int i = 0; i < 5; ++i) {
            for (int o = 0; o < 4; ++o) {
                this.tracert[i][o] = this.readC();
            }
        }
    }

    @Override
    protected void runImpl() {
        int n;
        L2ItemInstance combatFlag;
        L2ItemInstance[] serverNews;
        float points;
        L2PcInstance activeChar = this.getActiveChar();
        if (activeChar == null) {
            LOG.warn("EnterWorld failed! activeChar returned 'null'.");
            ((L2GameClient)this.getClient()).closeNow();
            return;
        }
        String[] address = new String[5];
        for (int i = 0; i < 5; ++i) {
            address[i] = this.tracert[i][0] + "." + this.tracert[i][1] + "." + this.tracert[i][2] + "." + this.tracert[i][3];
        }
        LoginServerThread.getInstance().sendClientTracert(activeChar.getAccountName(), address);
        ((L2GameClient)this.getClient()).setClientTracert(this.tracert);
        if (Configuration.general().restorePlayerInstance()) {
            activeChar.setInstanceId(InstanceManager.getInstance().getPlayerInstance(activeChar.getObjectId()));
        } else {
            int instanceId = InstanceManager.getInstance().getPlayerInstance(activeChar.getObjectId());
            if (instanceId > 0) {
                InstanceManager.getInstance().getInstance(instanceId).removePlayer(activeChar.getObjectId());
            }
        }
        if (Configuration.general().debug() && L2World.getInstance().findObject(activeChar.getObjectId()) != null) {
            LOG.warn("User already exists in Object ID map! User {} is a character clone.", (Object)activeChar.getName());
        }
        ((L2GameClient)this.getClient()).setState(L2GameClient.GameClientState.IN_GAME);
        if (activeChar.isGM()) {
            if (Configuration.general().gmStartupInvulnerable() && AdminData.getInstance().hasAccess("admin_invul", activeChar.getAccessLevel())) {
                activeChar.setIsInvul(true);
            }
            if (Configuration.general().gmStartupInvisible() && AdminData.getInstance().hasAccess("admin_invisible", activeChar.getAccessLevel())) {
                activeChar.setInvisible(true);
            }
            if (Configuration.general().gmStartupSilence() && AdminData.getInstance().hasAccess("admin_silence", activeChar.getAccessLevel())) {
                activeChar.setSilenceMode(true);
            }
            if (Configuration.general().gmStartupDietMode() && AdminData.getInstance().hasAccess("admin_diet", activeChar.getAccessLevel())) {
                activeChar.setDietMode(true);
                activeChar.refreshOverloaded();
            }
            AdminData.getInstance().addGm(activeChar, !Configuration.general().gmStartupAutoList() || !AdminData.getInstance().hasAccess("admin_gmliston", activeChar.getAccessLevel()));
            if (Configuration.general().gmGiveSpecialSkills()) {
                SkillTreesData.getInstance().addSkills(activeChar, false);
            }
            if (Configuration.general().gmGiveSpecialAuraSkills()) {
                SkillTreesData.getInstance().addSkills(activeChar, true);
            }
        }
        if (activeChar.getCurrentHp() < 0.5) {
            activeChar.setIsDead(true);
        }
        boolean showClanNotice = false;
        L2Clan clan = activeChar.getClan();
        if (clan != null) {
            activeChar.sendPacket(new PledgeSkillList(clan));
            EnterWorld.notifyClanMembers(activeChar);
            EnterWorld.notifySponsorOrApprentice(activeChar);
            AuctionableHall clanHall = ClanHallManager.getInstance().getClanHallByOwner(clan);
            if (clanHall != null && !clanHall.getPaid()) {
                activeChar.sendPacket(SystemMessageId.PAYMENT_FOR_YOUR_CLAN_HALL_HAS_NOT_BEEN_MADE_PLEASE_MAKE_PAYMENT_TO_YOUR_CLAN_WAREHOUSE_BY_S1_TOMORROW);
            }
            for (Siege siege : SiegeManager.getInstance().getSieges()) {
                if (!siege.isInProgress()) continue;
                if (siege.checkIsAttacker(clan)) {
                    activeChar.setSiegeState((byte)1);
                    activeChar.setSiegeSide(siege.getCastle().getResidenceId());
                    continue;
                }
                if (!siege.checkIsDefender(clan)) continue;
                activeChar.setSiegeState((byte)2);
                activeChar.setSiegeSide(siege.getCastle().getResidenceId());
            }
            for (FortSiege fortSiege : FortSiegeManager.getInstance().getSieges()) {
                if (!fortSiege.isInProgress()) continue;
                if (fortSiege.checkIsAttacker(clan)) {
                    activeChar.setSiegeState((byte)1);
                    activeChar.setSiegeSide(fortSiege.getFort().getResidenceId());
                    continue;
                }
                if (!fortSiege.checkIsDefender(clan)) continue;
                activeChar.setSiegeState((byte)2);
                activeChar.setSiegeSide(fortSiege.getFort().getResidenceId());
            }
            for (SiegableHall siegableHall : ClanHallSiegeManager.getInstance().getConquerableHalls().values()) {
                if (!siegableHall.isInSiege() || !siegableHall.isRegistered(clan)) continue;
                activeChar.setSiegeState((byte)1);
                activeChar.setSiegeSide(siegableHall.getId());
                activeChar.setIsInHideoutSiege(true);
            }
            this.sendPacket(new PledgeShowMemberListAll(clan, activeChar));
            this.sendPacket(new PledgeStatusChanged(clan));
            if (clan.getCastleId() > 0) {
                CastleManager.getInstance().getCastleByOwner(clan).giveResidentialSkills(activeChar);
            }
            if (clan.getFortId() > 0) {
                FortManager.getInstance().getFortByOwner(clan).giveResidentialSkills(activeChar);
            }
            showClanNotice = clan.isNoticeEnabled();
        }
        if (TerritoryWarManager.getInstance().getRegisteredTerritoryId(activeChar) > 0) {
            if (TerritoryWarManager.getInstance().isTWInProgress()) {
                activeChar.setSiegeState((byte)1);
            }
            activeChar.setSiegeSide(TerritoryWarManager.getInstance().getRegisteredTerritoryId(activeChar));
        }
        if (SevenSigns.getInstance().isSealValidationPeriod() && SevenSigns.getInstance().getSealOwner(3) != 0) {
            int cabal = SevenSigns.getInstance().getPlayerCabal(activeChar.getObjectId());
            if (cabal != 0) {
                if (cabal == SevenSigns.getInstance().getSealOwner(3)) {
                    activeChar.addSkill(CommonSkill.THE_VICTOR_OF_WAR.getSkill());
                } else {
                    activeChar.addSkill(CommonSkill.THE_VANQUISHED_OF_WAR.getSkill());
                }
            }
        } else {
            activeChar.removeSkill(CommonSkill.THE_VICTOR_OF_WAR.getSkill());
            activeChar.removeSkill(CommonSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
        if (Configuration.vitality().enabled() && Configuration.vitality().recoverVitalityOnReconnect() && (points = Configuration.vitality().getRateRecoveryOnReconnect() * (float)(System.currentTimeMillis() - activeChar.getLastAccess()) / 60000.0f) > 0.0f) {
            activeChar.updateVitalityPoints(points, false, true);
        }
        activeChar.broadcastUserInfo();
        if (Configuration.character().storeUISettings()) {
            activeChar.sendPacket(new ExUISetting(activeChar));
        }
        activeChar.getMacros().sendUpdate();
        this.sendPacket(new ItemList(activeChar, false));
        activeChar.queryGameGuard();
        this.sendPacket(new ExGetBookMarkInfoPacket(activeChar));
        this.sendPacket(new ShortCutInit(activeChar));
        activeChar.sendPacket(ExBasicActionList.STATIC_PACKET);
        activeChar.sendSkillList();
        activeChar.recalcHennaStats();
        activeChar.sendPacket(new HennaInfo(activeChar));
        Quest.playerEnter(activeChar);
        activeChar.sendPacket(new QuestList());
        if (Configuration.character().getPlayerSpawnProtection() > 0) {
            activeChar.setProtection(true);
        }
        activeChar.spawnMe(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        activeChar.getInventory().applyItemSkills();
        if (L2Event.isParticipant(activeChar)) {
            L2Event.restorePlayerEventStatus(activeChar);
        }
        if (Configuration.customs().allowWedding()) {
            EnterWorld.engage(activeChar);
            EnterWorld.notifyPartner(activeChar.getPartnerId());
        }
        if (activeChar.isCursedWeaponEquipped()) {
            CursedWeaponsManager.getInstance().getCursedWeapon(activeChar.getCursedWeaponEquippedId()).cursedOnLogin();
        }
        activeChar.updateEffectIcons();
        activeChar.sendPacket(new EtcStatusUpdate(activeChar));
        activeChar.sendPacket(new ExStorageMaxCount(activeChar));
        this.sendPacket(new FriendList(activeChar));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FRIEND_S1_HAS_LOGGED_IN);
        sm.addCharName(activeChar);
        if (activeChar.hasFriends()) {
            Iterator<Object> iterator = activeChar.getFriends().iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                L2Object obj = L2World.getInstance().findObject(n2);
                if (obj == null) continue;
                obj.sendPacket(sm);
            }
        }
        activeChar.sendPacket(SystemMessageId.WELCOME_TO_LINEAGE);
        activeChar.sendMessage(EnterWorld.getText("VGhpcyBzZXJ2ZXIgdXNlcyBMMkosIGEgcHJvamVjdCBmb3VuZGVkIGJ5IEwyQ2hlZg=="));
        activeChar.sendMessage(EnterWorld.getText("YW5kIGRldmVsb3BlZCBieSBMMkogVGVhbSBhdCB3d3cubDJqc2VydmVyLmNvbQ=="));
        activeChar.sendMessage(EnterWorld.getText("Q29weXJpZ2h0IDIwMDQtMjAyNQ=="));
        activeChar.sendMessage(EnterWorld.getText("VGhhbmsgeW91IGZvciAyMSB5ZWFycyE="));
        SevenSigns.getInstance().sendCurrentPeriodMsg(activeChar);
        AnnouncementsTable.getInstance().showAnnouncements(activeChar);
        if (showClanNotice) {
            NpcHtmlMessage notice = new NpcHtmlMessage();
            notice.setFile(activeChar.getHtmlPrefix(), "data/html/clanNotice.htm");
            notice.replace("%clan_name%", activeChar.getClan().getName());
            notice.replace("%notice_text%", activeChar.getClan().getNotice());
            notice.disableValidation();
            this.sendPacket(notice);
        } else if (Configuration.general().showServerNews() && (serverNews = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/servnews.htm")) != null) {
            this.sendPacket(new NpcHtmlMessage((String)serverNews));
        }
        if (Configuration.character().petitioningAllowed()) {
            PetitionManager.getInstance().checkPetitionMessages(activeChar);
        }
        if (activeChar.isAlikeDead()) {
            this.sendPacket(new Die(activeChar));
        }
        activeChar.onPlayerEnter();
        this.sendPacket(new SkillCoolTime(activeChar));
        this.sendPacket(new ExVoteSystemInfo(activeChar));
        this.sendPacket(new ExShowContactList(activeChar));
        for (L2ItemInstance item : activeChar.getInventory().getItems()) {
            if (item.isTimeLimitedItem()) {
                item.scheduleLifeTimeTask();
            }
            if (!item.isShadowItem() || !item.isEquipped()) continue;
            item.decreaseMana(false);
        }
        for (L2ItemInstance whItem : activeChar.getWarehouse().getItems()) {
            if (!whItem.isTimeLimitedItem()) continue;
            whItem.scheduleLifeTimeTask();
        }
        if (DimensionalRiftManager.getInstance().checkIfInRiftZone(activeChar.getX(), activeChar.getY(), activeChar.getZ(), false)) {
            DimensionalRiftManager.getInstance().teleportToWaitingRoom(activeChar);
        }
        if (activeChar.getClanJoinExpiryTime() > System.currentTimeMillis()) {
            activeChar.sendPacket(SystemMessageId.CLAN_MEMBERSHIP_TERMINATED);
        }
        if ((combatFlag = activeChar.getInventory().getItemByItemId(9819)) != null) {
            Fort fort = FortManager.getInstance().getFort(activeChar);
            if (fort != null) {
                FortSiegeManager.getInstance().dropCombatFlag(activeChar, fort.getResidenceId());
            } else {
                int slot = activeChar.getInventory().getSlotFromItem(combatFlag);
                activeChar.getInventory().unEquipItemInBodySlot(slot);
                activeChar.destroyItem("CombatFlag", combatFlag, null, true);
            }
        }
        if (!(activeChar.canOverrideCond(PcCondOverride.ZONE_CONDITIONS) || !activeChar.isInsideZone(ZoneId.SIEGE) || activeChar.isInSiege() && activeChar.getSiegeState() >= 2)) {
            activeChar.teleToLocation(TeleportWhereType.TOWN);
        }
        if (Configuration.general().allowMail() && MailManager.getInstance().hasUnreadPost(activeChar)) {
            this.sendPacket(ExNoticePostArrived.valueOf(false));
        }
        TvTEvent.onLogin(activeChar);
        AutoLootExtension.onLogin(activeChar);
        if (Configuration.customs().screenWelcomeMessageEnable()) {
            activeChar.sendPacket(new ExShowScreenMessage(Configuration.customs().getScreenWelcomeMessageText(), (int)Configuration.customs().getScreenWelcomeMessageTime()));
        }
        if ((n = activeChar.checkBirthDay()) == 0) {
            activeChar.sendPacket(SystemMessageId.YOUR_BIRTHDAY_GIFT_HAS_ARRIVED);
        } else if (n != -1) {
            SystemMessage sm1 = SystemMessage.getSystemMessage(SystemMessageId.THERE_ARE_S1_DAYS_UNTIL_YOUR_CHARACTERS_BIRTHDAY);
            sm1.addInt(n);
            activeChar.sendPacket(sm1);
        }
        if (!activeChar.getPremiumItemList().isEmpty()) {
            activeChar.sendPacket(ExNotifyPremiumItem.STATIC_PACKET);
        }
        activeChar.sendPacket(ActionFailed.STATIC_PACKET);
    }

    private static void engage(L2PcInstance cha) {
        int chaId = cha.getObjectId();
        for (Couple cl : CoupleManager.getInstance().getCouples()) {
            if (cl.getPlayer1Id() != chaId && cl.getPlayer2Id() != chaId) continue;
            if (cl.getMarried()) {
                cha.setMarried(true);
            }
            cha.setCoupleId(cl.getId());
            if (cl.getPlayer1Id() == chaId) {
                cha.setPartnerId(cl.getPlayer2Id());
                continue;
            }
            cha.setPartnerId(cl.getPlayer1Id());
        }
    }

    private static void notifyPartner(int partnerId) {
        L2PcInstance partner = L2World.getInstance().getPlayer(partnerId);
        if (partner != null) {
            partner.sendMessage("Your partner has logged in.");
        }
    }

    private static void notifyClanMembers(L2PcInstance activeChar) {
        L2Clan clan = activeChar.getClan();
        if (clan != null) {
            clan.getClanMember(activeChar.getObjectId()).setPlayerInstance(activeChar);
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_S1_LOGGED_IN);
            msg.addString(activeChar.getName());
            clan.broadcastToOtherOnlineMembers(msg, activeChar);
            clan.broadcastToOtherOnlineMembers(new PledgeShowMemberListUpdate(activeChar), activeChar);
        }
    }

    private static void notifySponsorOrApprentice(L2PcInstance activeChar) {
        L2PcInstance apprentice;
        if (activeChar.getSponsor() != 0) {
            L2PcInstance sponsor = L2World.getInstance().getPlayer(activeChar.getSponsor());
            if (sponsor != null) {
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOUR_APPRENTICE_S1_HAS_LOGGED_IN);
                msg.addString(activeChar.getName());
                sponsor.sendPacket(msg);
            }
        } else if (activeChar.getApprentice() != 0 && (apprentice = L2World.getInstance().getPlayer(activeChar.getApprentice())) != null) {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOUR_SPONSOR_C1_HAS_LOGGED_IN);
            msg.addString(activeChar.getName());
            apprentice.sendPacket(msg);
        }
    }

    private static String getText(String string) {
        return new String(Base64.getDecoder().decode(string));
    }

    @Override
    public String getType() {
        return _C__11_ENTERWORLD;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

