/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.EnterWorld;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.mmocore.ReceivablePacket;
import java.nio.BufferUnderflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class L2GameClientPacket
extends ReceivablePacket<L2GameClient> {
    private static final Logger LOG = LoggerFactory.getLogger(L2GameClientPacket.class);
    static final int MAX_ITEM_IN_PACKET = Math.max(Configuration.character().getMaximumSlotsForNoDwarf(), Math.max(Configuration.character().getMaximumSlotsForDwarf(), Configuration.character().getMaximumSlotsForGMPlayer()));

    public boolean read() {
        try {
            this.readImpl();
            return true;
        }
        catch (Exception e) {
            LOG.error("Client: {} - Failed reading: {} ; {}", ((L2GameClient)this.getClient()).toString(), this.getType(), e.getMessage(), e);
            if (e instanceof BufferUnderflowException) {
                ((L2GameClient)this.getClient()).onBufferUnderflow();
            }
            return false;
        }
    }

    protected abstract void readImpl();

    public void run() {
        block4: {
            try {
                L2PcInstance actor;
                this.runImpl();
                if (this.triggersOnActionRequest() && (actor = ((L2GameClient)this.getClient()).getActiveChar()) != null && (actor.isSpawnProtected() || actor.isInvul())) {
                    actor.onActionRequest();
                    if (Configuration.general().debug()) {
                        LOG.info("Spawn protection for player {} removed by packet: {}", (Object)actor.getName(), (Object)this.getType());
                    }
                }
            }
            catch (Throwable t) {
                LOG.error("Client: {} - Failed running: {} ; {}", ((L2GameClient)this.getClient()).toString(), this.getType(), t.getMessage(), t);
                if (!(this instanceof EnterWorld)) break block4;
                ((L2GameClient)this.getClient()).closeNow();
            }
        }
    }

    protected abstract void runImpl();

    protected final void sendPacket(L2GameServerPacket gsp) {
        ((L2GameClient)this.getClient()).sendPacket(gsp);
    }

    public void sendPacket(SystemMessageId id) {
        this.sendPacket(SystemMessage.getSystemMessage(id));
    }

    public abstract String getType();

    protected boolean triggersOnActionRequest() {
        return true;
    }

    protected final L2PcInstance getActiveChar() {
        return ((L2GameClient)this.getClient()).getActiveChar();
    }

    protected final void sendActionFailed() {
        if (this.getClient() != null) {
            ((L2GameClient)this.getClient()).sendPacket(ActionFailed.STATIC_PACKET);
        }
    }
}

