/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Logout
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(Logout.class);
    private static final Logger LOG_ACCOUNTING = LoggerFactory.getLogger("accounting");
    private static final String _C__00_LOGOUT = "[C] 00 Logout";

    @Override
    protected void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getActiveEnchantItemId() != -1 || player.getActiveEnchantAttrItemId() != -1) {
            if (Configuration.general().debug()) {
                LOG.debug("Player {} tried to logout while enchanting.", (Object)player.getName());
            }
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isLocked()) {
            LOG.warn("Player {} tried to logout during class change.", (Object)player.getName());
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(player)) {
            if (player.isGM() && Configuration.general().gmRestartFighting()) {
                return;
            }
            if (Configuration.general().debug()) {
                LOG.debug("Player {} tried to logout while fighting.", (Object)player.getName());
            }
            player.sendPacket(SystemMessageId.CANT_LOGOUT_WHILE_FIGHTING);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (L2Event.isParticipant(player)) {
            player.sendMessage("A superior power doesn't allow you to leave the event.");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isFestivalParticipant()) {
            if (SevenSignsFestival.getInstance().isFestivalInitialized()) {
                player.sendMessage("You cannot log out while you are a participant in a Festival.");
                player.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (player.isInParty()) {
                player.getParty().broadcastPacket(SystemMessage.sendString(player.getName() + " has been removed from the upcoming Festival."));
            }
        }
        player.removeFromBossZone();
        LOG_ACCOUNTING.info("Client {} logged out.", (Object)this.getClient());
        player.logout();
    }

    @Override
    public String getType() {
        return _C__00_LOGOUT;
    }
}

