/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.KeyPacket;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtocolVersion
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolVersion.class);
    private static final Logger LOG_ACCOUNTING = LoggerFactory.getLogger("accounting");
    private static final String _C__0E_PROTOCOLVERSION = "[C] 0E ProtocolVersion";
    private int _version;

    @Override
    protected void readImpl() {
        this._version = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._version == -2) {
            if (Configuration.general().debug()) {
                LOG.info("Ping received");
            }
            ((L2GameClient)this.getClient()).close((L2GameServerPacket)null);
        } else if (!Configuration.server().getAllowedProtocolRevisions().contains(this._version)) {
            LOG_ACCOUNTING.warn("Wrong protocol, {}, {}", (Object)this._version, (Object)this.getClient());
            KeyPacket pk = new KeyPacket(((L2GameClient)this.getClient()).enableCrypt(), 0);
            ((L2GameClient)this.getClient()).setProtocolOk(false);
            ((L2GameClient)this.getClient()).close(pk);
        } else {
            if (Configuration.general().debug()) {
                LOG.debug("Client Protocol Revision is ok: {}", (Object)this._version);
            }
            KeyPacket pk = new KeyPacket(((L2GameClient)this.getClient()).enableCrypt(), 1);
            ((L2GameClient)this.getClient()).sendPacket(pk);
            ((L2GameClient)this.getClient()).setProtocolOk(true);
        }
    }

    @Override
    public String getType() {
        return _C__0E_PROTOCOLVERSION;
    }
}

