/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.data.xml.impl.SkillTreesData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestAcquireSkillInfo
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAcquireSkillInfo.class);
    private static final String _C__73_REQUESTACQUIRESKILLINFO = "[C] 73 RequestAcquireSkillInfo";
    private int _id;
    private int _level;
    private AcquireSkillType _skillType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = AcquireSkillType.getAcquireSkillType(this.readD());
    }

    @Override
    protected void runImpl() {
        if (this._id <= 0 || this._level <= 0) {
            LOG.warn("Invalid Id: {} or level: {}!", (Object)this._id, (Object)this._level);
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Npc trainer = activeChar.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(activeChar) && !activeChar.isGM()) {
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(this._id, this._level);
        if (skill == null) {
            LOG.warn("Skill Id: {} level: {} is undefined!", (Object)this._id, (Object)this._level);
            return;
        }
        int prevSkillLevel = activeChar.getSkillLevel(this._id);
        if (prevSkillLevel > 0 && this._skillType != AcquireSkillType.TRANSFER && this._skillType != AcquireSkillType.SUBPLEDGE) {
            if (prevSkillLevel == this._level) {
                LOG.warn("Player {} is requesting info for a skill that already knows, Id: {} level: {}!", activeChar, this._id, this._level);
            } else if (prevSkillLevel != this._level - 1) {
                LOG.warn("Player {} is requesting info for skill Id: {} level {} without knowing it's previous level!", activeChar, this._id, this._level);
            }
        }
        if (this._skillType == AcquireSkillType.PLEDGE && !activeChar.isClanLeader()) {
            return;
        }
        if (!(this._skillType != AcquireSkillType.SUBPLEDGE || activeChar.isClanLeader() && activeChar.hasClanPrivilege(ClanPrivilege.CL_TROOPS_FAME))) {
            return;
        }
        L2SkillLearn skillLearn = SkillTreesData.getInstance().getSkillLearn(this._skillType, this._id, this._level, activeChar);
        if (skillLearn == null) {
            return;
        }
        this.sendPacket(new AcquireSkillInfo(activeChar, this._skillType, skillLearn));
    }

    @Override
    public String getType() {
        return _C__73_REQUESTACQUIRESKILLINFO;
    }
}

