/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.EnchantItemData;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.enchant.EnchantResultType;
import com.l2jserver.gameserver.model.items.enchant.EnchantScroll;
import com.l2jserver.gameserver.model.items.enchant.EnchantSupportItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.EnchantResult;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestEnchantItem
extends L2GameClientPacket {
    private static final Logger LOG_ENCHANT_ITEM = LoggerFactory.getLogger("enchant_item");
    private static final String _C__5F_REQUESTENCHANTITEM = "[C] 5F RequestEnchantItem";
    private int _objectId;
    private int _supportId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._supportId = this.readD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null || this._objectId == 0) {
            return;
        }
        if (!activeChar.isOnline() || ((L2GameClient)this.getClient()).isDetached()) {
            activeChar.setActiveEnchantItemId(-1);
            return;
        }
        if (activeChar.isProcessingTransaction() || activeChar.isInStoreMode()) {
            activeChar.sendPacket(SystemMessageId.CANNOT_ENCHANT_WHILE_STORE);
            activeChar.setActiveEnchantItemId(-1);
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
        L2ItemInstance scroll = activeChar.getInventory().getItemByObjectId(activeChar.getActiveEnchantItemId());
        L2ItemInstance support = activeChar.getInventory().getItemByObjectId(activeChar.getActiveEnchantSupportItemId());
        if (item == null || scroll == null) {
            activeChar.setActiveEnchantItemId(-1);
            return;
        }
        EnchantScroll scrollTemplate = EnchantItemData.getInstance().getEnchantScroll(scroll);
        if (scrollTemplate == null) {
            return;
        }
        EnchantSupportItem supportTemplate = null;
        if (support != null) {
            if (support.getObjectId() != this._supportId) {
                activeChar.setActiveEnchantItemId(-1);
                return;
            }
            supportTemplate = EnchantItemData.getInstance().getSupportItem(support);
        }
        if (!scrollTemplate.isValid(item, supportTemplate)) {
            activeChar.sendPacket(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION);
            activeChar.setActiveEnchantItemId(-1);
            activeChar.sendPacket(new EnchantResult(2, 0, 0));
            return;
        }
        if (activeChar.getActiveEnchantTimestamp() == 0L || System.currentTimeMillis() - activeChar.getActiveEnchantTimestamp() < 2000L) {
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " use autoenchant program ");
            activeChar.setActiveEnchantItemId(-1);
            activeChar.sendPacket(new EnchantResult(2, 0, 0));
            return;
        }
        scroll = activeChar.getInventory().destroyItem("Enchant", scroll.getObjectId(), 1L, activeChar, (Object)item);
        if (scroll == null) {
            activeChar.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to enchant with a scroll he doesn't have");
            activeChar.setActiveEnchantItemId(-1);
            activeChar.sendPacket(new EnchantResult(2, 0, 0));
            return;
        }
        if (support != null && (support = activeChar.getInventory().destroyItem("Enchant", support.getObjectId(), 1L, activeChar, (Object)item)) == null) {
            activeChar.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to enchant with a support item he doesn't have");
            activeChar.setActiveEnchantItemId(-1);
            activeChar.sendPacket(new EnchantResult(2, 0, 0));
            return;
        }
        InventoryUpdate iu = new InventoryUpdate();
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (item.getOwnerId() != activeChar.getObjectId() || item.isEnchantable() == 0) {
                activeChar.sendPacket(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION);
                activeChar.setActiveEnchantItemId(-1);
                activeChar.sendPacket(new EnchantResult(2, 0, 0));
                return;
            }
            EnchantResultType resultType = scrollTemplate.calculateSuccess(activeChar, item, supportTemplate);
            switch (resultType) {
                case ERROR: {
                    activeChar.sendPacket(SystemMessageId.INAPPROPRIATE_ENCHANT_CONDITION);
                    activeChar.setActiveEnchantItemId(-1);
                    activeChar.sendPacket(new EnchantResult(2, 0, 0));
                    break;
                }
                case SUCCESS: {
                    Skill enchant4Skill;
                    int maxEnchantAnnounce;
                    L2Item it = item.getItem();
                    if (scrollTemplate.getChance(activeChar, item) > 0.0) {
                        item.setEnchantLevel(item.getEnchantLevel() + 1);
                        item.updateDatabase();
                    }
                    activeChar.sendPacket(new EnchantResult(0, 0, 0));
                    if (Configuration.general().logItemEnchants()) {
                        LOG_ENCHANT_ITEM.info("ENCHANTED {} using {} and {} by {}.", item, scroll, support, activeChar);
                    }
                    int minEnchantAnnounce = item.isArmor() ? 6 : 7;
                    int n = maxEnchantAnnounce = item.isArmor() ? 0 : 15;
                    if (item.getEnchantLevel() == minEnchantAnnounce || item.getEnchantLevel() == maxEnchantAnnounce) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_SUCCESSFULY_ENCHANTED_A_S2_S3);
                        sm.addCharName(activeChar);
                        sm.addInt(item.getEnchantLevel());
                        sm.addItemName(item);
                        activeChar.broadcastPacket(sm);
                        Skill skill = CommonSkill.FIREWORK.getSkill();
                        if (skill != null) {
                            activeChar.broadcastPacket(new MagicSkillUse(activeChar, activeChar, skill.getId(), skill.getLevel(), skill.getHitTime(), skill.getReuseDelay()));
                        }
                    }
                    if (!item.isArmor() || item.getEnchantLevel() != 4 || !item.isEquipped() || (enchant4Skill = it.getEnchant4Skill()) == null) break;
                    activeChar.addSkill(enchant4Skill, false);
                    activeChar.sendSkillList();
                    break;
                }
                case FAILURE: {
                    if (scrollTemplate.isSafe()) {
                        activeChar.sendPacket(SystemMessageId.SAFE_ENCHANT_FAILED);
                        activeChar.sendPacket(new EnchantResult(5, 0, 0));
                        if (!Configuration.general().logItemEnchants()) break;
                        LOG_ENCHANT_ITEM.info("FAILED_SAFE_ENCHANTING {} using {} and {} by {}.", item, scroll, support, activeChar);
                        break;
                    }
                    if (item.isEquipped()) {
                        L2ItemInstance[] unequiped;
                        if (item.getEnchantLevel() > 0) {
                            sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                            sm.addInt(item.getEnchantLevel());
                            sm.addItemName(item);
                            activeChar.sendPacket(sm);
                        } else {
                            sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                            sm.addItemName(item);
                            activeChar.sendPacket(sm);
                        }
                        for (L2ItemInstance itm : unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(item.getLocationSlot())) {
                            iu.addModifiedItem(itm);
                        }
                        activeChar.sendPacket(iu);
                        activeChar.broadcastUserInfo();
                    }
                    if (scrollTemplate.isBlessed()) {
                        activeChar.sendPacket(SystemMessageId.BLESSED_ENCHANT_FAILED);
                        item.setEnchantLevel(0);
                        item.updateDatabase();
                        activeChar.sendPacket(new EnchantResult(3, 0, 0));
                        if (!Configuration.general().logItemEnchants()) break;
                        LOG_ENCHANT_ITEM.info("FAILED_BLESSED_ENCHANTING {} using {} and {} by {}.", item, scroll, support, activeChar);
                        break;
                    }
                    item = activeChar.getInventory().destroyItem("Enchant", item, activeChar, null);
                    if (item == null) {
                        Util.handleIllegalPlayerAction(activeChar, "Unable to delete item on enchant failure from player " + activeChar.getName() + ", possible cheater !");
                        activeChar.setActiveEnchantItemId(-1);
                        activeChar.sendPacket(new EnchantResult(2, 0, 0));
                        if (Configuration.general().logItemEnchants()) {
                            LOG_ENCHANT_ITEM.warn("CANNOT_DESTROY {} using {} and {} by {}.", item, scroll, support, activeChar);
                        }
                        return;
                    }
                    L2World.getInstance().removeObject(item);
                    int crystalId = item.getItem().getCrystalItemId();
                    if (crystalId != 0 && item.getItem().isCrystallizable()) {
                        int count = item.getCrystalCount() - (item.getItem().getCrystalCount() + 1) / 2;
                        count = Math.max(count, 1);
                        activeChar.getInventory().addItem("Enchant", crystalId, count, activeChar, item);
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                        sm.addItemName(crystalId);
                        sm.addLong(count);
                        activeChar.sendPacket(sm);
                        activeChar.sendPacket(new EnchantResult(1, crystalId, count));
                    } else {
                        activeChar.sendPacket(new EnchantResult(4, 0, 0));
                    }
                    if (!Configuration.general().logItemEnchants()) break;
                    LOG_ENCHANT_ITEM.warn("FAILED_ENCHANTING {} using {} and {} by {}.", item, scroll, support, activeChar);
                }
            }
            StatusUpdate su = new StatusUpdate(activeChar);
            su.addAttribute(14, activeChar.getCurrentLoad());
            activeChar.sendPacket(su);
            if (!Configuration.general().forceInventoryUpdate()) {
                if (scroll.getCount() == 0L) {
                    iu.addRemovedItem(scroll);
                } else {
                    iu.addModifiedItem(scroll);
                }
                if (item.getCount() == 0L) {
                    iu.addRemovedItem(item);
                } else {
                    iu.addModifiedItem(item);
                }
                if (support != null) {
                    if (support.getCount() == 0L) {
                        iu.addRemovedItem(support);
                    } else {
                        iu.addModifiedItem(support);
                    }
                }
                activeChar.sendPacket(iu);
            } else {
                activeChar.sendPacket(new ItemList(activeChar, true));
            }
            activeChar.broadcastUserInfo();
            activeChar.setActiveEnchantItemId(-1);
        }
    }

    @Override
    public String getType() {
        return _C__5F_REQUESTENCHANTITEM;
    }
}

