/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.EnchantSkillGroupsData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfoDetail;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillResult;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestExEnchantSkillSafe
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExEnchantSkillSafe.class);
    private static final Logger LOG_ENCHANT_SKILL = LoggerFactory.getLogger("enchant_skill");
    private static final String _C__D0_32_REQUESTEXENCHANTSKILLSAFE = "[C] D0:32 RequestExEnchantSkillSafe";
    private int _skillId;
    private int _skillLvl;

    @Override
    protected void readImpl() {
        this._skillId = this.readD();
        this._skillLvl = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._skillId <= 0 || this._skillLvl <= 0) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getClassId().level() < 3) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_IN_THIS_CLASS);
            return;
        }
        if (player.getLevel() < 76) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ON_THIS_LEVEL);
            return;
        }
        if (!player.isAllowedToEnchantSkills()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ATTACKING_TRANSFORMED_BOAT);
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(this._skillId, this._skillLvl);
        if (skill == null) {
            return;
        }
        int costMultiplier = Configuration.general().getSafeEnchantCostMultipiler();
        int reqItemId = 9627;
        L2EnchantSkillLearn s = EnchantSkillGroupsData.getInstance().getSkillEnchantmentBySkillId(this._skillId);
        if (s == null) {
            return;
        }
        L2EnchantSkillGroup.EnchantSkillHolder esd = s.getEnchantSkillHolder(this._skillLvl);
        int beforeEnchantSkillLevel = player.getSkillLevel(this._skillId);
        if (beforeEnchantSkillLevel != s.getMinSkillLevel(this._skillLvl)) {
            return;
        }
        int requiredSp = esd.getSpCost() * costMultiplier;
        int requireditems = esd.getAdenaCost() * costMultiplier;
        byte rate = esd.getRate(player);
        if (player.getSp() >= requiredSp) {
            L2ItemInstance spb = player.getInventory().getItemByItemId(reqItemId);
            if (spb == null) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            if (player.getInventory().getAdena() < (long)requireditems) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            boolean check = player.removeSp(requiredSp);
            check &= player.destroyItem("Consume", spb.getObjectId(), 1L, (L2Object)player, true);
            if (!(check &= player.destroyItemByItemId("Consume", 57, requireditems, player, true))) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            if (Rnd.get((int)100) <= rate) {
                if (Configuration.general().logSkillEnchants()) {
                    LOG_ENCHANT_SKILL.info("SAFE_ENCHANTED {} using {} with rate {} by {}.", skill, spb, (int)rate, player);
                }
                player.addSkill(skill, true);
                if (Configuration.general().debug()) {
                    LOG.debug("Learned skill ID: {} Level: {} for {} SP, {} Adena.", this._skillId, this._skillLvl, requiredSp, requireditems);
                }
                player.sendPacket(ExEnchantSkillResult.valueOf(true));
                sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_SUCCEEDED_IN_ENCHANTING_THE_SKILL_S1);
                sm.addSkillName(this._skillId);
                player.sendPacket(sm);
            } else {
                if (Configuration.general().logSkillEnchants()) {
                    LOG_ENCHANT_SKILL.info("FAILED_SAFE_ENCHANTING {} using {} with rate {} by {}.", skill, spb, (int)rate, player);
                }
                sm = SystemMessage.getSystemMessage(SystemMessageId.SKILL_ENCHANT_FAILED_S1_LEVEL_WILL_REMAIN);
                sm.addSkillName(this._skillId);
                player.sendPacket(sm);
                player.sendPacket(ExEnchantSkillResult.valueOf(false));
            }
            player.sendPacket(new UserInfo(player));
            player.sendPacket(new ExBrExtraUserInfo(player));
            player.sendSkillList();
            int afterEnchantSkillLevel = player.getSkillLevel(this._skillId);
            player.sendPacket(new ExEnchantSkillInfo(this._skillId, afterEnchantSkillLevel));
            player.sendPacket(new ExEnchantSkillInfoDetail(1, this._skillId, afterEnchantSkillLevel + 1, player));
            player.updateShortCuts(this._skillId, afterEnchantSkillLevel);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DONT_HAVE_ENOUGH_SP_TO_ENCHANT_THAT_SKILL);
            player.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _C__D0_32_REQUESTEXENCHANTSKILLSAFE;
    }
}

