/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestGetItemFromPet
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestGetItemFromPet.class);
    private static final String _C__2C_REQUESTGETITEMFROMPET = "[C] 2C RequestGetItemFromPet";
    private int _objectId;
    private long _amount;
    private int _unknown;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._amount = this.readQ();
        this._unknown = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (this._amount <= 0L || player == null || !player.hasPet()) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("getfrompet")) {
            player.sendMessage("You get items from pet too fast.");
            return;
        }
        L2PetInstance pet = (L2PetInstance)player.getSummon();
        if (player.getActiveEnchantItemId() != -1) {
            return;
        }
        L2ItemInstance item = pet.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        if (this._amount > item.getCount()) {
            Util.handleIllegalPlayerAction(player, ((Object)((Object)this)).getClass().getSimpleName() + ": Character " + player.getName() + " of account " + player.getAccountName() + " tried to get item with oid " + this._objectId + " from pet but has invalid count " + this._amount + " item count: " + item.getCount());
            return;
        }
        if (pet.transferItem("Transfer", this._objectId, this._amount, player.getInventory(), player, pet) == null) {
            LOG.warn("Invalid item transfer request: {}(pet) --> {}", (Object)pet.getName(), (Object)player.getName());
        }
    }

    @Override
    public String getType() {
        return _C__2C_REQUESTGETITEMFROMPET;
    }
}

