/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.PartyDistributionType;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.AskJoinParty;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestJoinParty
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestJoinParty.class);
    private static final String _C__42_REQUESTJOINPARTY = "[C] 42 RequestJoinParty";
    private String _name;
    private int _partyDistributionTypeId;

    @Override
    protected void readImpl() {
        this._name = this.readS();
        this._partyDistributionTypeId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance requestor = ((L2GameClient)this.getClient()).getActiveChar();
        L2PcInstance target = L2World.getInstance().getPlayer(this._name);
        if (requestor == null) {
            return;
        }
        if (target == null) {
            requestor.sendPacket(SystemMessageId.FIRST_SELECT_USER_TO_INVITE_TO_PARTY);
            return;
        }
        if (target.getClient() == null || target.getClient().isDetached()) {
            requestor.sendMessage("Player is in offline mode.");
            return;
        }
        if (requestor.isPartyBanned()) {
            requestor.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REPORTED_SO_PARTY_NOT_ALLOWED);
            requestor.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (target.isPartyBanned()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_REPORTED_AND_CANNOT_PARTY);
            sm.addCharName(target);
            requestor.sendPacket(sm);
            return;
        }
        if (!target.isVisibleFor(requestor)) {
            requestor.sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
            return;
        }
        if (target.isInParty()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_IN_PARTY);
            sm.addString(target.getName());
            requestor.sendPacket(sm);
            return;
        }
        if (BlockList.isBlocked(target, requestor)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_ADDED_YOU_TO_IGNORE_LIST);
            sm.addCharName(target);
            requestor.sendPacket(sm);
            return;
        }
        if (target == requestor) {
            requestor.sendPacket(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET);
            return;
        }
        if (target.isCursedWeaponEquipped() || requestor.isCursedWeaponEquipped()) {
            requestor.sendPacket(SystemMessageId.INCORRECT_TARGET);
            return;
        }
        if (target.isJailed() || requestor.isJailed()) {
            requestor.sendMessage("You cannot invite a player while is in Jail.");
            return;
        }
        if ((target.isInOlympiadMode() || requestor.isInOlympiadMode()) && (target.isInOlympiadMode() != requestor.isInOlympiadMode() || target.getOlympiadGameId() != requestor.getOlympiadGameId() || target.getOlympiadSide() != requestor.getOlympiadSide())) {
            requestor.sendPacket(SystemMessageId.A_USER_CURRENTLY_PARTICIPATING_IN_THE_OLYMPIAD_CANNOT_SEND_PARTY_AND_FRIEND_INVITATIONS);
            return;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_INVITED_TO_PARTY);
        sm.addCharName(target);
        requestor.sendPacket(sm);
        if (!requestor.isInParty()) {
            this.createNewParty(target, requestor);
        } else if (requestor.getParty().isInDimensionalRift()) {
            requestor.sendMessage("You cannot invite a player when you are in the Dimensional Rift.");
        } else {
            this.addTargetToParty(target, requestor);
        }
    }

    private void addTargetToParty(L2PcInstance target, L2PcInstance requestor) {
        L2Party party = requestor.getParty();
        if (!party.isLeader(requestor)) {
            requestor.sendPacket(SystemMessageId.ONLY_LEADER_CAN_INVITE);
            return;
        }
        if (party.getMemberCount() >= 9) {
            requestor.sendPacket(SystemMessageId.PARTY_FULL);
            return;
        }
        if (party.getPendingInvitation() && !party.isInvitationRequestExpired()) {
            requestor.sendPacket(SystemMessageId.WAITING_FOR_ANOTHER_REPLY);
            return;
        }
        if (!target.isProcessingRequest()) {
            requestor.onTransactionRequest(target);
            target.sendPacket(new AskJoinParty(requestor.getName(), party.getDistributionType()));
            party.setPendingInvitation(true);
            if (Configuration.general().debug()) {
                LOG.debug("Sent out a party invitation to: {}", (Object)target.getName());
            }
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            sm.addString(target.getName());
            requestor.sendPacket(sm);
            if (Configuration.general().debug()) {
                LOG.warn("{} already received a party invitation", (Object)requestor.getName());
            }
        }
    }

    private void createNewParty(L2PcInstance target, L2PcInstance requestor) {
        PartyDistributionType partyDistributionType = PartyDistributionType.findById(this._partyDistributionTypeId);
        if (partyDistributionType == null) {
            return;
        }
        if (!target.isProcessingRequest()) {
            target.sendPacket(new AskJoinParty(requestor.getName(), partyDistributionType));
            target.setActiveRequester(requestor);
            requestor.onTransactionRequest(target);
            requestor.setPartyDistributionType(partyDistributionType);
            if (Configuration.general().debug()) {
                LOG.debug("Sent out a party invitation to: {}", (Object)target.getName());
            }
        } else {
            requestor.sendPacket(SystemMessageId.WAITING_FOR_ANOTHER_REPLY);
            if (Configuration.general().debug()) {
                LOG.warn("{} already received a party invitation", (Object)requestor.getName());
            }
        }
    }

    @Override
    public String getType() {
        return _C__42_REQUESTJOINPARTY;
    }
}

