/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.QuestList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestQuestAbort
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestQuestAbort.class);
    private static final String _C__63_REQUESTQUESTABORT = "[C] 63 RequestQuestAbort";
    private int _questId;

    @Override
    protected void readImpl() {
        this._questId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        Quest qe = QuestManager.getInstance().getQuest(this._questId);
        if (qe != null) {
            QuestState qs = activeChar.getQuestState(qe.getName());
            if (qs != null) {
                qs.exitQuest(true);
                activeChar.sendPacket(new QuestList());
            } else if (Configuration.general().debug()) {
                LOG.info("Player '{}' try to abort quest {} but he didn't have it started.", (Object)activeChar.getName(), (Object)qe.getName());
            }
        } else if (Configuration.general().debug()) {
            LOG.warn("Quest (id='{}') not found.", (Object)this._questId);
        }
    }

    @Override
    public String getType() {
        return _C__63_REQUESTQUESTABORT;
    }
}

