/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import com.l2jserver.gameserver.network.serverpackets.RestartResponse;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestRestart
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(RequestRestart.class);
    private static final Logger LOG_ACCOUNTING = LoggerFactory.getLogger("accounting");
    private static final String _C__57_REQUESTRESTART = "[C] 57 RequestRestart";

    @Override
    protected void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getActiveEnchantItemId() != -1 || player.getActiveEnchantAttrItemId() != -1) {
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        if (player.isLocked()) {
            LOG.warn("Player {} tried to restart during class change.", (Object)player.getName());
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        if (player.getPrivateStoreType() != PrivateStoreType.NONE) {
            player.sendMessage("Cannot restart while trading");
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        if (!(!AttackStanceTaskManager.getInstance().hasAttackStanceTask(player) || player.isGM() && Configuration.general().gmRestartFighting())) {
            if (Configuration.general().debug()) {
                LOG.debug("Player {} tried to logout while fighting.", (Object)player.getName());
            }
            player.sendPacket(SystemMessageId.CANT_RESTART_WHILE_FIGHTING);
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        if (player.isFestivalParticipant()) {
            if (SevenSignsFestival.getInstance().isFestivalInitialized()) {
                player.sendMessage("You cannot restart while you are a participant in a festival.");
                this.sendPacket(RestartResponse.valueOf(false));
                return;
            }
            L2Party playerParty = player.getParty();
            if (playerParty != null) {
                player.getParty().broadcastString(player.getName() + " has been removed from the upcoming festival.");
            }
        }
        if (player.isBlockedFromExit()) {
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        player.removeFromBossZone();
        L2GameClient client = (L2GameClient)this.getClient();
        LOG_ACCOUNTING.info("Client {} restarted.", (Object)client);
        player.setClient(null);
        player.deleteMe();
        client.setActiveChar(null);
        AntiFeedManager.getInstance().onDisconnect(client);
        client.setState(L2GameClient.GameClientState.AUTHED);
        this.sendPacket(RestartResponse.valueOf(true));
        CharSelectionInfo cl = new CharSelectionInfo(client.getAccountName(), client.getSessionId().playOkID1);
        this.sendPacket(cl);
        client.setCharSelection(cl.getCharInfo());
    }

    @Override
    public String getType() {
        return _C__57_REQUESTRESTART;
    }
}

