/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.data.xml.impl.BuyListData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.model.holders.UniqueItemHolder;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBuySellList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.List;

public final class RequestSellItem
extends L2GameClientPacket {
    private static final String _C__37_REQUESTSELLITEM = "[C] 37 RequestSellItem";
    private static final int BATCH_LENGTH = 16;
    private int _listId;
    private List<UniqueItemHolder> _items = null;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        int size = this.readD();
        if (size <= 0 || size > MAX_ITEM_IN_PACKET || size * 16 != this._buf.remaining()) {
            return;
        }
        this._items = new ArrayList<UniqueItemHolder>(size);
        for (int i = 0; i < size; ++i) {
            int objectId = this.readD();
            int itemId = this.readD();
            long count = this.readQ();
            if (objectId < 1 || itemId < 1 || count < 1L) {
                this._items = null;
                return;
            }
            this._items.add(new UniqueItemHolder(itemId, objectId, count));
        }
    }

    @Override
    protected void runImpl() {
        this.processSell();
    }

    protected void processSell() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("buy")) {
            player.sendMessage("You are buying too fast.");
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!Configuration.character().karmaPlayerCanShop() && player.getKarma() > 0) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Object target = player.getTarget();
        IIdentifiable merchant = null;
        if (!player.isGM()) {
            if (target == null || !player.isInsideRadius(target, 150, true, false) || player.getInstanceId() != target.getInstanceId()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (target instanceof L2MerchantInstance) {
                merchant = (L2Character)target;
            } else {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        if (merchant == null && !player.isGM()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2BuyList buyList = BuyListData.getInstance().getBuyList(this._listId);
        if (buyList == null) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false BuyList list_id " + this._listId);
            return;
        }
        if (merchant != null && !buyList.isNpcAllowed(merchant.getId())) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        long totalPrice = 0L;
        for (UniqueItemHolder i : this._items) {
            L2ItemInstance item = player.checkItemManipulation(i.getObjectId(), i.getCount(), "sell");
            if (item == null || !item.isSellable()) continue;
            long price = item.getReferencePrice() / 2;
            if (Configuration.character().getMaxAdena() / i.getCount() < price || (totalPrice += price * i.getCount()) > Configuration.character().getMaxAdena()) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to purchase over " + Configuration.character().getMaxAdena() + " adena worth of goods.");
                return;
            }
            if (Configuration.general().allowRefund()) {
                item = player.getInventory().transferItem("Sell", i.getObjectId(), i.getCount(), player.getRefund(), player, merchant);
                continue;
            }
            item = player.getInventory().destroyItem("Sell", i.getObjectId(), i.getCount(), player, (Object)merchant);
        }
        player.addAdena("Sell", totalPrice, (L2Object)merchant, false);
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
        player.sendPacket(new ExBuySellList(player, true));
    }

    @Override
    public String getType() {
        return _C__37_REQUESTSELLITEM;
    }
}

