/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.data.sql.impl.ClanTable;
import com.l2jserver.gameserver.data.sql.impl.CrestTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Crest;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;

public final class RequestSetAllyCrest
extends L2GameClientPacket {
    private static final String _C__91_REQUESTSETALLYCREST = "[C] 91 RequestSetAllyCrest";
    private int _length;
    private byte[] _data = null;

    @Override
    protected void readImpl() {
        this._length = this.readD();
        if (this._length > 192) {
            return;
        }
        this._data = new byte[this._length];
        this.readB(this._data);
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._length < 0) {
            activeChar.sendMessage("File transfer error.");
            return;
        }
        if (this._length > 192) {
            activeChar.sendPacket(SystemMessageId.ADJUST_IMAGE_8_12);
            return;
        }
        if (activeChar.getAllyId() == 0) {
            activeChar.sendPacket(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER);
            return;
        }
        L2Clan leaderClan = ClanTable.getInstance().getClan(activeChar.getAllyId());
        if (activeChar.getClanId() != leaderClan.getId() || !activeChar.isClanLeader()) {
            activeChar.sendPacket(SystemMessageId.FEATURE_ONLY_FOR_ALLIANCE_LEADER);
            return;
        }
        if (this._length == 0) {
            if (leaderClan.getAllyCrestId() != 0) {
                leaderClan.changeAllyCrest(0, false);
            }
        } else {
            L2Crest crest = CrestTable.getInstance().createCrest(this._data, L2Crest.CrestType.ALLY);
            if (crest != null) {
                leaderClan.changeAllyCrest(crest.getId(), false);
                activeChar.sendPacket(SystemMessageId.CLAN_CREST_WAS_SUCCESSFULLY_REGISTRED);
            }
        }
    }

    @Override
    public String getType() {
        return _C__91_REQUESTSETALLYCREST;
    }
}

