/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.handler.ChatHandler;
import com.l2jserver.gameserver.handler.IChatHandler;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.BaseEvent;
import com.l2jserver.gameserver.model.events.impl.character.player.PlayerChat;
import com.l2jserver.gameserver.model.events.returns.ChatFilterReturn;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Say2
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(Say2.class);
    private static final String _C__49_SAY2 = "[C] 49 Say2";
    private static final Logger LOG_CHAT = LoggerFactory.getLogger("chat");
    public static final int ALL = 0;
    public static final int SHOUT = 1;
    public static final int TELL = 2;
    public static final int PARTY = 3;
    public static final int CLAN = 4;
    public static final int GM = 5;
    public static final int PETITION_PLAYER = 6;
    public static final int PETITION_GM = 7;
    public static final int TRADE = 8;
    public static final int ALLIANCE = 9;
    public static final int ANNOUNCEMENT = 10;
    public static final int BOAT = 11;
    public static final int L2FRIEND = 12;
    public static final int MSNCHAT = 13;
    public static final int PARTYMATCH_ROOM = 14;
    public static final int PARTYROOM_COMMANDER = 15;
    public static final int PARTYROOM_ALL = 16;
    public static final int HERO_VOICE = 17;
    public static final int CRITICAL_ANNOUNCE = 18;
    public static final int SCREEN_ANNOUNCE = 19;
    public static final int BATTLEFIELD = 20;
    public static final int MPCC_ROOM = 21;
    public static final int NPC_ALL = 22;
    public static final int NPC_SHOUT = 23;
    private static final String[] CHAT_NAMES = new String[]{"ALL", "SHOUT", "TELL", "PARTY", "CLAN", "GM", "PETITION_PLAYER", "PETITION_GM", "TRADE", "ALLIANCE", "ANNOUNCEMENT", "BOAT", "L2FRIEND", "MSNCHAT", "PARTYMATCH_ROOM", "PARTYROOM_COMMANDER", "PARTYROOM_ALL", "HERO_VOICE", "CRITICAL_ANNOUNCE", "SCREEN_ANNOUNCE", "BATTLEFIELD", "MPCC_ROOM"};
    private static final String[] WALKER_COMMAND_LIST = new String[]{"USESKILL", "USEITEM", "BUYITEM", "SELLITEM", "SAVEITEM", "LOADITEM", "MSG", "DELAY", "LABEL", "JMP", "CALL", "RETURN", "MOVETO", "NPCSEL", "NPCDLG", "DLGSEL", "CHARSTATUS", "POSOUTRANGE", "POSINRANGE", "GOHOME", "SAY", "EXIT", "PAUSE", "STRINDLG", "STRNOTINDLG", "CHANGEWAITTYPE", "FORCEATTACK", "ISMEMBER", "REQUESTJOINPARTY", "REQUESTOUTPARTY", "QUITPARTY", "MEMBERSTATUS", "CHARBUFFS", "ITEMCOUNT", "FOLLOWTELEPORT"};
    private String _text;
    private int _type;
    private String _target;

    @Override
    protected void readImpl() {
        this._text = this.readS();
        this._type = this.readD();
        this._target = this._type == 2 ? this.readS() : null;
    }

    @Override
    protected void runImpl() {
        IChatHandler handler;
        L2PcInstance activeChar;
        if (Configuration.general().debug()) {
            LOG.info("Msg Type = '{}' Text = '{}'.", (Object)this._type, (Object)this._text);
        }
        if ((activeChar = ((L2GameClient)this.getClient()).getActiveChar()) == null) {
            return;
        }
        if (this._type < 0 || this._type >= CHAT_NAMES.length) {
            LOG.warn("Invalid type: {} Player : {} text: {}", this._type, activeChar.getName(), this._text);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            activeChar.logout();
            return;
        }
        if (this._text.isEmpty()) {
            LOG.warn("{}: sending empty text. Possible packet hack!", (Object)activeChar.getName());
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            activeChar.logout();
            return;
        }
        if (!activeChar.isGM() && (this._text.indexOf(8) >= 0 && this._text.length() > 500 || this._text.indexOf(8) < 0 && this._text.length() > 105)) {
            activeChar.sendPacket(SystemMessageId.DONT_SPAM);
            return;
        }
        if (Configuration.customs().l2WalkerProtection() && this._type == 2 && this.checkBot(this._text)) {
            Util.handleIllegalPlayerAction(activeChar, "Client Emulator Detect: Player " + activeChar.getName() + " using l2walker.");
            return;
        }
        if (activeChar.isCursedWeaponEquipped() && (this._type == 8 || this._type == 1)) {
            activeChar.sendPacket(SystemMessageId.SHOUT_AND_TRADE_CHAT_CANNOT_BE_USED_WHILE_POSSESSING_CURSED_WEAPON);
            return;
        }
        if (activeChar.isChatBanned() && this._text.charAt(0) != '.') {
            if (activeChar.getEffectList().getFirstEffect(L2EffectType.CHAT_BLOCK) != null) {
                activeChar.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REPORTED_SO_CHATTING_NOT_ALLOWED);
            } else if (Configuration.general().getBanChatChannels().contains(this._type)) {
                activeChar.sendPacket(SystemMessageId.CHATTING_IS_CURRENTLY_PROHIBITED);
            }
            return;
        }
        if (activeChar.isJailed() && Configuration.general().jailDisableChat() && (this._type == 2 || this._type == 1 || this._type == 8 || this._type == 17)) {
            activeChar.sendMessage("You can not chat with players outside of the jail.");
            return;
        }
        if (this._type == 6 && activeChar.isGM()) {
            this._type = 7;
        }
        if (Configuration.general().logChat()) {
            if (this._type == 2) {
                LOG_CHAT.info("{} {} says [{}] to {}.", CHAT_NAMES[this._type], activeChar.getName(), this._text, this._target);
            } else {
                LOG_CHAT.info("{} {} says [{}].", CHAT_NAMES[this._type], activeChar.getName(), this._text);
            }
        }
        if (this._text.indexOf(8) >= 0 && !this.parseAndPublishItem(activeChar)) {
            return;
        }
        ChatFilterReturn filter = EventDispatcher.getInstance().notifyEvent((BaseEvent)new PlayerChat(activeChar, L2World.getInstance().getPlayer(this._target), this._text, this._type), ChatFilterReturn.class);
        if (filter != null) {
            this._text = filter.getFilteredText();
        }
        if (Configuration.general().useChatFilter()) {
            this.checkText();
        }
        if ((handler = ChatHandler.getInstance().getHandler(this._type)) != null) {
            handler.handleChat(this._type, activeChar, this._target, this._text);
        } else {
            LOG.info("No handler registered for ChatType: {} Player: {}", (Object)this._type, (Object)this.getClient());
        }
    }

    private boolean checkBot(String text) {
        for (String botCommand : WALKER_COMMAND_LIST) {
            if (!text.startsWith(botCommand)) continue;
            return true;
        }
        return false;
    }

    private void checkText() {
        String filteredText = this._text;
        for (String pattern : Configuration.general().getChatFilter()) {
            filteredText = filteredText.replaceAll("(?i)" + pattern, Configuration.general().getChatFilterChars());
        }
        this._text = filteredText;
    }

    private boolean parseAndPublishItem(L2PcInstance owner) {
        int pos1 = -1;
        while ((pos1 = this._text.indexOf(8, pos1)) > -1) {
            int pos = this._text.indexOf("ID=", pos1);
            if (pos == -1) {
                return false;
            }
            StringBuilder result = new StringBuilder(9);
            pos += 3;
            while (Character.isDigit(this._text.charAt(pos))) {
                result.append(this._text.charAt(pos++));
            }
            int id = Integer.parseInt(result.toString());
            L2Object item = L2World.getInstance().findObject(id);
            if (item instanceof L2ItemInstance) {
                if (owner.getInventory().getItemByObjectId(id) == null) {
                    LOG.info("{} trying publish item which doesnt own! ID:{}", (Object)this.getClient(), (Object)id);
                    return false;
                }
            } else {
                LOG.info("{} trying publish object which is not item! Object:{}", (Object)this.getClient(), (Object)item);
                return false;
            }
            ((L2ItemInstance)item).publish();
            pos1 = this._text.indexOf(8, pos) + 1;
            if (pos1 != 0) continue;
            LOG.info("{} sent invalid publish item msg! ID:{}", (Object)this.getClient(), (Object)id);
            return false;
        }
        return true;
    }

    @Override
    public String getType() {
        return _C__49_SAY2;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

