/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TradeDone
extends L2GameClientPacket {
    private static final Logger LOG = LoggerFactory.getLogger(TradeDone.class);
    private int _response;

    @Override
    protected void readImpl() {
        this._response = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("trade")) {
            player.sendMessage("You are trading too fast.");
            return;
        }
        TradeList trade = player.getActiveTradeList();
        if (trade == null) {
            if (Configuration.general().debug()) {
                LOG.warn("player.getTradeList == null in {} for player {}", (Object)this.getType(), (Object)player.getName());
            }
            return;
        }
        if (trade.isLocked()) {
            return;
        }
        if (this._response == 1) {
            if (trade.getPartner() == null || L2World.getInstance().getPlayer(trade.getPartner().getObjectId()) == null) {
                player.cancelActiveTrade();
                player.sendPacket(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME);
                return;
            }
            if (trade.getOwner().getActiveEnchantItemId() != -1 || trade.getPartner().getActiveEnchantItemId() != -1) {
                return;
            }
            if (!player.getAccessLevel().allowTransaction()) {
                player.cancelActiveTrade();
                player.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
                return;
            }
            if (player.getInstanceId() != trade.getPartner().getInstanceId() && player.getInstanceId() != -1) {
                player.cancelActiveTrade();
                return;
            }
            if (player.calculateDistance(trade.getPartner(), true, false) > 150.0) {
                player.cancelActiveTrade();
                return;
            }
            trade.confirm();
        } else {
            player.cancelActiveTrade();
        }
    }

    @Override
    public String getType() {
        return "[C] 1C TradeDone";
    }
}

