/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.data.xml.impl.AdminData;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class Die
extends L2GameServerPacket {
    private final int _charObjId;
    private final boolean _canTeleport;
    private final boolean _sweepable;
    private L2AccessLevel _access = AdminData.getInstance().getAccessLevel(0);
    private L2Clan _clan;
    private final L2Character _activeChar;
    private boolean _isJailed;
    private boolean _staticRes = false;

    public Die(L2Character cha) {
        this._charObjId = cha.getObjectId();
        this._activeChar = cha;
        if (cha.isPlayer()) {
            L2PcInstance player = cha.getActingPlayer();
            this._access = player.getAccessLevel();
            this._clan = player.getClan();
            this._isJailed = player.isJailed();
        }
        this._canTeleport = cha.canRevive() && !cha.isPendingRevive();
        this._sweepable = cha.isSweepActive();
    }

    @Override
    protected final void writeImpl() {
        this.writeC(0);
        this.writeD(this._charObjId);
        this.writeD(this._canTeleport ? 1 : 0);
        if (this._activeChar.isPlayer()) {
            if (!OlympiadManager.getInstance().isRegistered(this._activeChar.getActingPlayer()) && !this._activeChar.isOnEvent()) {
                this._staticRes = this._activeChar.getInventory().haveItemForSelfResurrection();
            }
            if (this._access.allowFixedRes()) {
                this._staticRes = true;
            }
        }
        if (this._canTeleport && this._clan != null && !this._isJailed) {
            boolean isInCastleDefense = false;
            boolean isInFortDefense = false;
            L2SiegeClan siegeClan = null;
            Castle castle = CastleManager.getInstance().getCastle(this._activeChar);
            Fort fort = FortManager.getInstance().getFort(this._activeChar);
            SiegableHall hall = ClanHallSiegeManager.getInstance().getNearbyClanHall(this._activeChar);
            if (castle != null && castle.getSiege().isInProgress()) {
                siegeClan = castle.getSiege().getAttackerClan(this._clan);
                if (siegeClan == null && castle.getSiege().checkIsDefender(this._clan)) {
                    isInCastleDefense = true;
                }
            } else if (fort != null && fort.getSiege().isInProgress() && (siegeClan = fort.getSiege().getAttackerClan(this._clan)) == null && fort.getSiege().checkIsDefender(this._clan)) {
                isInFortDefense = true;
            }
            this.writeD(this._clan.getHideoutId() > 0 ? 1 : 0);
            this.writeD(this._clan.getCastleId() > 0 || isInCastleDefense ? 1 : 0);
            this.writeD(TerritoryWarManager.getInstance().getHQForClan(this._clan) != null || siegeClan != null && !isInCastleDefense && !isInFortDefense && !siegeClan.getFlag().isEmpty() || hall != null && hall.getSiege().checkIsAttacker(this._clan) ? 1 : 0);
            this.writeD(this._sweepable ? 1 : 0);
            this.writeD(this._staticRes ? 1 : 0);
            this.writeD(this._clan.getFortId() > 0 || isInFortDefense ? 1 : 0);
        } else {
            this.writeD(0);
            this.writeD(0);
            this.writeD(0);
            this.writeD(this._sweepable ? 1 : 0);
            this.writeD(this._staticRes ? 1 : 0);
            this.writeD(0);
        }
    }
}

