/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.cleft.CleftMatch;
import com.l2jserver.gameserver.model.cleft.CleftParticipant;
import com.l2jserver.gameserver.model.cleft.CleftTeam;
import com.l2jserver.gameserver.network.serverpackets.AbstractExCleftPacket;
import java.util.Map;
import java.util.Objects;

public abstract class ExCleftList
extends AbstractExCleftPacket {
    private final ListAction _action;

    protected ExCleftList(ListAction action) {
        Objects.requireNonNull(action);
        this._action = action;
    }

    protected void writeParticipant(CleftParticipant participant, boolean writeName) {
        this.writeD(participant.getPlayer().getObjectId());
        if (writeName) {
            this.writeS(participant.getPlayer().getName());
        }
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(148);
        this.writeD(this._action.ordinal() - 1);
    }

    private static enum ListAction {
        CLOSE,
        TOTAL,
        ADD,
        REMOVE,
        CHANGE_TEAM;

    }

    public static final class ChangeTeam
    extends ExCleftList {
        private final CleftTeam _oldTeam;
        private final CleftTeam _newTeam;
        private final CleftParticipant _player;

        public ChangeTeam(CleftTeam oldTeam, CleftTeam newTeam, CleftParticipant player) {
            super(ListAction.CHANGE_TEAM);
            Objects.requireNonNull(oldTeam);
            Objects.requireNonNull(newTeam);
            Objects.requireNonNull(player);
            this._oldTeam = oldTeam;
            this._newTeam = newTeam;
            this._player = player;
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeParticipant(this._player, false);
            this.writeTeamId(this._oldTeam);
            this.writeTeamId(this._newTeam);
        }
    }

    public static final class Remove
    extends ExCleftList {
        private final CleftTeam _team;
        private final CleftParticipant _player;

        public Remove(CleftTeam team, CleftParticipant player) {
            super(ListAction.REMOVE);
            Objects.requireNonNull(team);
            Objects.requireNonNull(player);
            this._team = team;
            this._player = player;
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeTeamId(this._team);
            this.writeParticipant(this._player, false);
        }
    }

    public static final class Add
    extends ExCleftList {
        private final CleftTeam _team;
        private final CleftParticipant _player;

        public Add(CleftTeam team, CleftParticipant player) {
            super(ListAction.ADD);
            Objects.requireNonNull(team);
            Objects.requireNonNull(player);
            this._team = team;
            this._player = player;
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeTeamId(this._team);
            this.writeParticipant(this._player, true);
        }
    }

    public static final class Total
    extends ExCleftList {
        private final CleftMatch _match;

        public Total(CleftMatch match) {
            super(ListAction.TOTAL);
            Objects.requireNonNull(match);
            this._match = match;
        }

        private void writeTeamParticipants(CleftTeam team) {
            Map<Integer, CleftParticipant> participants = team.getParticipants();
            this.writeD(participants.size());
            for (CleftParticipant participant : participants.values()) {
                this.writeParticipant(participant, true);
            }
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
            this.writeD(this._match.getMinTeamMembers());
            this.writeD(this._match.isBalanced() ? 1 : 0);
            this.writeTeamParticipants(this._match.getBlueTeam());
            this.writeTeamParticipants(this._match.getRedTeam());
        }
    }

    public static final class Close
    extends ExCleftList {
        public Close() {
            super(ListAction.CLOSE);
        }

        @Override
        protected void writeImpl() {
            super.writeImpl();
        }
    }
}

