/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.FortSiegeSpawn;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class ExShowFortressMapInfo
extends L2GameServerPacket {
    private final Fort _fortress;

    public ExShowFortressMapInfo(Fort fortress) {
        this._fortress = fortress;
    }

    @Override
    protected void writeImpl() {
        block11: {
            block10: {
                this.writeC(254);
                this.writeH(125);
                this.writeD(this._fortress.getResidenceId());
                this.writeD(this._fortress.getSiege().isInProgress() ? 1 : 0);
                this.writeD(this._fortress.getFortSize());
                List<FortSiegeSpawn> commanders = FortSiegeManager.getInstance().getCommanderSpawnList(this._fortress.getResidenceId());
                if (commanders == null || commanders.size() == 0 || !this._fortress.getSiege().isInProgress()) break block10;
                switch (commanders.size()) {
                    case 3: {
                        for (FortSiegeSpawn spawn : commanders) {
                            if (this.isSpawned(spawn.getId())) {
                                this.writeD(0);
                                continue;
                            }
                            this.writeD(1);
                        }
                        break block11;
                    }
                    case 4: {
                        int count = 0;
                        for (FortSiegeSpawn spawn : commanders) {
                            if (++count == 4) {
                                this.writeD(1);
                            }
                            if (this.isSpawned(spawn.getId())) {
                                this.writeD(0);
                                continue;
                            }
                            this.writeD(1);
                        }
                        break;
                    }
                }
                break block11;
            }
            for (int i = 0; i < this._fortress.getFortSize(); ++i) {
                this.writeD(0);
            }
        }
    }

    private boolean isSpawned(int npcId) {
        boolean ret = false;
        for (L2Spawn spawn : this._fortress.getSiege().getCommanders()) {
            if (spawn.getId() != npcId) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

