/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.data.sql.impl.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FriendListExtended
extends L2GameServerPacket {
    private final List<FriendInfo> _info;

    public FriendListExtended(L2PcInstance player) {
        if (!player.hasFriends()) {
            this._info = Collections.emptyList();
            return;
        }
        this._info = new ArrayList<FriendInfo>(player.getFriends().size());
        for (int objId : player.getFriends()) {
            String name = CharNameTable.getInstance().getNameById(objId);
            L2PcInstance friend = L2World.getInstance().getPlayer(objId);
            if (friend == null) {
                try {
                    Connection con = ConnectionFactory.getInstance().getConnection();
                    try {
                        PreparedStatement statement = con.prepareStatement("SELECT char_name, online, classid, level FROM characters WHERE charId = ?");
                        try {
                            statement.setInt(1, objId);
                            try (ResultSet rs = statement.executeQuery();){
                                if (!rs.next()) continue;
                                this._info.add(new FriendInfo(objId, rs.getString(1), rs.getInt(2) == 1, rs.getInt(3), rs.getInt(4)));
                            }
                        }
                        finally {
                            if (statement == null) continue;
                            statement.close();
                        }
                    }
                    finally {
                        if (con == null) continue;
                        con.close();
                    }
                }
                catch (Exception exception) {}
                continue;
            }
            this._info.add(new FriendInfo(objId, name, friend.isOnline(), friend.getClassId().getId(), friend.getLevel()));
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(88);
        this.writeD(this._info.size());
        for (FriendInfo info : this._info) {
            this.writeD(info._objId);
            this.writeS(info._name);
            this.writeD(info._online ? 1 : 0);
            this.writeD(info._online ? info._objId : 0);
            this.writeD(info._classid);
            this.writeD(info._level);
        }
    }

    private static class FriendInfo {
        int _objId;
        String _name;
        boolean _online;
        int _classid;
        int _level;

        FriendInfo(int objId, String name, boolean online, int classid, int level) {
            this._objId = objId;
            this._name = name;
            this._online = online;
            this._classid = classid;
            this._level = level;
        }
    }
}

