/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public final class ServerObjectInfo
extends L2GameServerPacket {
    private final L2Npc _activeChar;
    private final int _x;
    private final int _y;
    private final int _z;
    private final int _heading;
    private final int _idTemplate;
    private final boolean _isAttackable;
    private final double _collisionHeight;
    private final double _collisionRadius;
    private final String _name;

    public ServerObjectInfo(L2Npc activeChar, L2Character actor) {
        this._activeChar = activeChar;
        this._idTemplate = this._activeChar.getTemplate().getDisplayId();
        this._isAttackable = this._activeChar.isAutoAttackable(actor);
        this._collisionHeight = this._activeChar.getCollisionHeight();
        this._collisionRadius = this._activeChar.getCollisionRadius();
        this._x = this._activeChar.getX();
        this._y = this._activeChar.getY();
        this._z = this._activeChar.getZ();
        this._heading = this._activeChar.getHeading();
        this._name = this._activeChar.getTemplate().isUsingServerSideName() ? this._activeChar.getTemplate().getName() : "";
    }

    @Override
    protected void writeImpl() {
        this.writeC(146);
        this.writeD(this._activeChar.getObjectId());
        this.writeD(this._idTemplate + 1000000);
        this.writeS(this._name);
        this.writeD(this._isAttackable ? 1 : 0);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeD(this._heading);
        this.writeF(1.0);
        this.writeF(1.0);
        this.writeF(this._collisionRadius);
        this.writeF(this._collisionHeight);
        this.writeD((int)(this._isAttackable ? this._activeChar.getCurrentHp() : 0.0));
        this.writeD(this._isAttackable ? this._activeChar.getMaxHp() : 0);
        this.writeD(1);
        this.writeD(0);
    }
}

