/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public final class SpawnItem
extends L2GameServerPacket {
    private final int _objectId;
    private final int _itemId;
    private final int _x;
    private final int _y;
    private final int _z;
    private final int _stackable;
    private final long _count;

    public SpawnItem(L2Object obj) {
        this._objectId = obj.getObjectId();
        this._x = obj.getX();
        this._y = obj.getY();
        this._z = obj.getZ();
        if (obj instanceof L2ItemInstance) {
            L2ItemInstance item = (L2ItemInstance)obj;
            this._itemId = item.getDisplayId();
            this._stackable = item.isStackable() ? 1 : 0;
            this._count = item.getCount();
        } else {
            this._itemId = obj.getPoly().getPolyId();
            this._stackable = 0;
            this._count = 1L;
        }
    }

    @Override
    protected void writeImpl() {
        this.writeC(5);
        this.writeD(this._objectId);
        this.writeD(this._itemId);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeD(this._stackable);
        this.writeQ(this._count);
        this.writeD(0);
        this.writeD(0);
    }
}

