/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;
import java.util.ArrayList;
import java.util.List;

public final class WareHouseDepositList
extends AbstractItemPacket {
    public static final int PRIVATE = 1;
    public static final int CLAN = 4;
    public static final int CASTLE = 3;
    public static final int FREIGHT = 1;
    private final long _playerAdena;
    private final List<L2ItemInstance> _items = new ArrayList<L2ItemInstance>();
    private final int _whType;

    public WareHouseDepositList(L2PcInstance player, int type) {
        this._whType = type;
        this._playerAdena = player.getAdena();
        boolean isPrivate = this._whType == 1;
        for (L2ItemInstance temp : player.getInventory().getAvailableItems(true, isPrivate, false)) {
            if (temp == null || !temp.isDepositable(isPrivate)) continue;
            this._items.add(temp);
        }
    }

    @Override
    protected void writeImpl() {
        this.writeC(65);
        this.writeH(this._whType);
        this.writeQ(this._playerAdena);
        this.writeH(this._items.size());
        for (L2ItemInstance item : this._items) {
            this.writeItem(item);
            this.writeD(item.getObjectId());
        }
    }
}

