/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.pathfinding.geonodes;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.pathfinding.AbstractNode;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.PathFinding;
import com.l2jserver.gameserver.pathfinding.geonodes.GeoNode;
import com.l2jserver.gameserver.pathfinding.geonodes.GeoNodeLoc;
import com.l2jserver.gameserver.pathfinding.utils.FastNodeList;
import com.l2jserver.gameserver.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoPathFinding
extends PathFinding {
    private static final Logger LOG = LoggerFactory.getLogger(GeoPathFinding.class);
    private static final Map<Short, ByteBuffer> _pathNodes = new HashMap<Short, ByteBuffer>();
    private static final Map<Short, IntBuffer> _pathNodesIndex = new HashMap<Short, IntBuffer>();

    public static GeoPathFinding getInstance() {
        return SingletonHolder._instance;
    }

    @Override
    public boolean pathNodesExist(short regionoffset) {
        return _pathNodesIndex.containsKey(regionoffset);
    }

    @Override
    public List<AbstractNodeLoc> findPath(int x, int y, int z, int tx, int ty, int tz, int instanceId, boolean playable) {
        int gx = x - -294912 >> 4;
        int gy = y - -262144 >> 4;
        short gz = (short)z;
        int gtx = tx - -294912 >> 4;
        int gty = ty - -262144 >> 4;
        short gtz = (short)tz;
        GeoNode start = this.readNode(gx, gy, gz);
        GeoNode end = this.readNode(gtx, gty, gtz);
        if (start == null || end == null) {
            return null;
        }
        if (Math.abs(((GeoNodeLoc)start.getLoc()).getZ() - z) > 55) {
            return null;
        }
        if (Math.abs(((GeoNodeLoc)end.getLoc()).getZ() - tz) > 55) {
            return null;
        }
        if (start == end) {
            return null;
        }
        Location temp = GeoData.getInstance().moveCheck(x, y, z, ((GeoNodeLoc)start.getLoc()).getX(), ((GeoNodeLoc)start.getLoc()).getY(), ((GeoNodeLoc)start.getLoc()).getZ(), instanceId);
        if (temp.getX() != ((GeoNodeLoc)start.getLoc()).getX() || temp.getY() != ((GeoNodeLoc)start.getLoc()).getY()) {
            return null;
        }
        temp = GeoData.getInstance().moveCheck(tx, ty, tz, ((GeoNodeLoc)end.getLoc()).getX(), ((GeoNodeLoc)end.getLoc()).getY(), ((GeoNodeLoc)end.getLoc()).getZ(), instanceId);
        if (temp.getX() != ((GeoNodeLoc)end.getLoc()).getX() || temp.getY() != ((GeoNodeLoc)end.getLoc()).getY()) {
            return null;
        }
        return this.searchByClosest2(start, end);
    }

    private List<AbstractNodeLoc> searchByClosest2(GeoNode start, GeoNode end) {
        FastNodeList visited = new FastNodeList(550);
        LinkedList<GeoNode> to_visit = new LinkedList<GeoNode>();
        to_visit.add(start);
        int targetX = ((GeoNodeLoc)end.getLoc()).getNodeX();
        int targetY = ((GeoNodeLoc)end.getLoc()).getNodeY();
        int i = 0;
        while (i < 550) {
            GeoNode node;
            try {
                node = (GeoNode)to_visit.removeFirst();
            }
            catch (Exception e) {
                return null;
            }
            if (node.equals(end)) {
                return this.constructPath2(node);
            }
            ++i;
            visited.add(node);
            node.attachNeighbors(this.readNeighbors(node));
            GeoNode[] neighbors = node.getNeighbors();
            if (neighbors == null) continue;
            for (GeoNode n : neighbors) {
                if (visited.containsRev(n) || to_visit.contains(n)) continue;
                boolean added = false;
                n.setParent(node);
                int dx = targetX - ((GeoNodeLoc)n.getLoc()).getNodeX();
                int dy = targetY - ((GeoNodeLoc)n.getLoc()).getNodeY();
                n.setCost(dx * dx + dy * dy);
                for (int index = 0; index < to_visit.size(); ++index) {
                    if (((GeoNode)to_visit.get(index)).getCost() <= n.getCost()) continue;
                    to_visit.add(index, n);
                    added = true;
                    break;
                }
                if (added) continue;
                to_visit.addLast(n);
            }
        }
        return null;
    }

    private List<AbstractNodeLoc> constructPath2(AbstractNode<GeoNodeLoc> node) {
        LinkedList<AbstractNodeLoc> path = new LinkedList<AbstractNodeLoc>();
        int previousDirectionX = -1000;
        int previousDirectionY = -1000;
        while (node.getParent() != null) {
            int directionX = node.getLoc().getNodeX() - node.getParent().getLoc().getNodeX();
            int directionY = node.getLoc().getNodeY() - node.getParent().getLoc().getNodeY();
            if (directionX != previousDirectionX || directionY != previousDirectionY) {
                previousDirectionX = directionX;
                previousDirectionY = directionY;
                path.addFirst(node.getLoc());
            }
            node = node.getParent();
        }
        return path;
    }

    private GeoNode[] readNeighbors(GeoNode n) {
        short new_node_y;
        short new_node_x;
        GeoNode newNode;
        byte neighbor;
        if (n.getLoc() == null) {
            return null;
        }
        int idx = n.getNeighborsIdx();
        int node_x = ((GeoNodeLoc)n.getLoc()).getNodeX();
        int node_y = ((GeoNodeLoc)n.getLoc()).getNodeY();
        short regoffset = this.getRegionOffset(this.getRegionX(node_x), this.getRegionY(node_y));
        ByteBuffer pn = _pathNodes.get(regoffset);
        ArrayList<GeoNode> neighbors = new ArrayList<GeoNode>(8);
        if ((neighbor = pn.get(idx++)) > 0 && (newNode = this.readNode(new_node_x = (short)node_x, new_node_y = (short)(node_y - 1), neighbor = (byte)(neighbor - 1))) != null) {
            neighbors.add(newNode);
        }
        if ((neighbor = pn.get(idx++)) > 0 && (newNode = this.readNode(new_node_x = (short)(node_x + 1), new_node_y = (short)(node_y - 1), neighbor = (byte)(neighbor - 1))) != null) {
            neighbors.add(newNode);
        }
        if ((neighbor = pn.get(idx++)) > 0 && (newNode = this.readNode(new_node_x = (short)(node_x + 1), new_node_y = (short)node_y, neighbor = (byte)(neighbor - 1))) != null) {
            neighbors.add(newNode);
        }
        if ((neighbor = pn.get(idx++)) > 0 && (newNode = this.readNode(new_node_x = (short)(node_x + 1), new_node_y = (short)(node_y + 1), neighbor = (byte)(neighbor - 1))) != null) {
            neighbors.add(newNode);
        }
        if ((neighbor = pn.get(idx++)) > 0 && (newNode = this.readNode(new_node_x = (short)node_x, new_node_y = (short)(node_y + 1), neighbor = (byte)(neighbor - 1))) != null) {
            neighbors.add(newNode);
        }
        if ((neighbor = pn.get(idx++)) > 0 && (newNode = this.readNode(new_node_x = (short)(node_x - 1), new_node_y = (short)(node_y + 1), neighbor = (byte)(neighbor - 1))) != null) {
            neighbors.add(newNode);
        }
        if ((neighbor = pn.get(idx++)) > 0 && (newNode = this.readNode(new_node_x = (short)(node_x - 1), new_node_y = (short)node_y, neighbor = (byte)(neighbor - 1))) != null) {
            neighbors.add(newNode);
        }
        if ((neighbor = pn.get(idx++)) > 0 && (newNode = this.readNode(new_node_x = (short)(node_x - 1), new_node_y = (short)(node_y - 1), neighbor = (byte)(neighbor - 1))) != null) {
            neighbors.add(newNode);
        }
        GeoNode[] result = new GeoNode[neighbors.size()];
        return neighbors.toArray(result);
    }

    private GeoNode readNode(short node_x, short node_y, byte layer) {
        short regoffset = this.getRegionOffset(this.getRegionX(node_x), this.getRegionY(node_y));
        if (!this.pathNodesExist(regoffset)) {
            return null;
        }
        short nbx = this.getNodeBlock(node_x);
        short nby = this.getNodeBlock(node_y);
        int idx = _pathNodesIndex.get(regoffset).get((nby << 8) + nbx);
        ByteBuffer pn = _pathNodes.get(regoffset);
        byte nodes = pn.get(idx);
        idx += layer * 10 + 1;
        if (nodes < layer) {
            LOG.warn("SmthWrong!");
        }
        short node_z = pn.getShort(idx);
        return new GeoNode(new GeoNodeLoc(node_x, node_y, node_z), idx += 2);
    }

    private GeoNode readNode(int gx, int gy, short z) {
        short node_x = this.getNodePos(gx);
        short node_y = this.getNodePos(gy);
        short regoffset = this.getRegionOffset(this.getRegionX(node_x), this.getRegionY(node_y));
        if (!this.pathNodesExist(regoffset)) {
            return null;
        }
        short nbx = this.getNodeBlock(node_x);
        short nby = this.getNodeBlock(node_y);
        int idx = _pathNodesIndex.get(regoffset).get((nby << 8) + nbx);
        ByteBuffer pn = _pathNodes.get(regoffset);
        int idx2 = 0;
        short last_z = Short.MIN_VALUE;
        for (byte nodes = pn.get(idx++); nodes > 0; nodes = (byte)(nodes - 1)) {
            short node_z = pn.getShort(idx);
            if (Math.abs(last_z - z) > Math.abs(node_z - z)) {
                last_z = node_z;
                idx2 = idx + 2;
            }
            idx += 10;
        }
        return new GeoNode(new GeoNodeLoc(node_x, node_y, last_z), idx2);
    }

    private GeoPathFinding() {
        try (Stream<String> fileLines = Files.lines(Paths.get(Configuration.geodata().getPathnodePath().getPath(), "pn_index.txt"), StandardCharsets.UTF_8);){
            LOG.info("Path Engine: - Loading Path Nodes...");
            fileLines.map(String::trim).filter(l -> !l.isEmpty()).forEach(line -> {
                String[] parts = line.split("_");
                if (parts.length < 2 || !Util.isDigit(parts[0]) || !Util.isDigit(parts[1])) {
                    LOG.warn("Invalid pathnode entry: '{}', must be in format 'XX_YY', where X and Y - integers", line);
                    return;
                }
                byte rx = Byte.parseByte(parts[0]);
                byte ry = Byte.parseByte(parts[1]);
                this.loadPathNodeFile(rx, ry);
            });
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), e);
            throw new Error("Failed to read pn_index file.");
        }
    }

    private void loadPathNodeFile(byte rx, byte ry) {
        if (rx < 11 || rx > 26 || ry < 10 || ry > 26) {
            LOG.warn("Failed to Load PathNode File: invalid region {},{}{}", rx, ry, Configuration.EOL);
            return;
        }
        short regionoffset = this.getRegionOffset(rx, ry);
        File file = new File(Configuration.geodata().getPathnodePath(), rx + "_" + ry + ".pn");
        LOG.info("Path Engine: - Loading: {} -> region offset: {} X: {} Y: {}", file.getName(), regionoffset, rx, ry);
        int node = 0;
        int index = 0;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");
             FileChannel roChannel = raf.getChannel();){
            int size = (int)roChannel.size();
            MappedByteBuffer nodes = Configuration.geodata().forceGeoData() ? roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size).load() : roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            IntBuffer indexs = IntBuffer.allocate(65536);
            while (node < 65536) {
                byte layer = nodes.get(index);
                indexs.put(node++, index);
                index += layer * 10 + 1;
            }
            _pathNodesIndex.put(regionoffset, indexs);
            _pathNodes.put(regionoffset, nodes);
        }
        catch (Exception e) {
            LOG.warn("Failed to Load PathNode File: {} : {}", file.getAbsolutePath(), e.getMessage(), e);
        }
    }

    private static class SingletonHolder {
        protected static final GeoPathFinding _instance = new GeoPathFinding();

        private SingletonHolder() {
        }
    }
}

