/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.script.ScriptDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptPackage {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptPackage.class);
    private final List<ScriptDocument> _scriptFiles = new ArrayList<ScriptDocument>();
    private final List<String> _otherFiles = new ArrayList<String>();
    private final String _name;

    public ScriptPackage(ZipFile pack) {
        this._name = pack.getName();
        this.addFiles(pack);
    }

    public List<String> getOtherFiles() {
        return this._otherFiles;
    }

    public List<ScriptDocument> getScriptFiles() {
        return this._scriptFiles;
    }

    private void addFiles(ZipFile pack) {
        Enumeration<? extends ZipEntry> e = pack.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.getName().endsWith(".xml")) {
                try {
                    this._scriptFiles.add(new ScriptDocument(entry.getName(), pack.getInputStream(entry)));
                }
                catch (IOException io) {
                    LOG.warn(io.getMessage(), io);
                }
                continue;
            }
            if (entry.isDirectory()) continue;
            this._otherFiles.add(entry.getName());
        }
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        if (this.getScriptFiles().isEmpty() && this.getOtherFiles().isEmpty()) {
            return "Empty Package.";
        }
        StringBuilder out = new StringBuilder();
        out.append("package Name: ");
        out.append(this.getName());
        out.append(Configuration.EOL);
        if (!this.getScriptFiles().isEmpty()) {
            out.append("Xml Script Files...").append(Configuration.EOL);
            for (ScriptDocument script : this.getScriptFiles()) {
                out.append(script.getName());
                out.append(Configuration.EOL);
            }
        }
        if (!this.getOtherFiles().isEmpty()) {
            out.append("Other Files...").append(Configuration.EOL);
            for (String fileName : this.getOtherFiles()) {
                out.append(fileName);
                out.append(Configuration.EOL);
            }
        }
        return out.toString();
    }
}

