/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.status;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.handler.ITelnetHandler;
import com.l2jserver.gameserver.handler.TelnetHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GameStatusThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(GameStatusThread.class);
    private final Socket _cSocket;
    private final PrintWriter _print;
    private final BufferedReader _read;
    private final int _uptime;

    private void telnetOutput(int type, String text) {
        if (Configuration.general().developer()) {
            if (type == 1) {
                System.out.println("TELNET | " + text);
            } else if (type == 2) {
                System.out.print("TELNET | " + text);
            } else if (type == 3) {
                System.out.print(text);
            } else if (type == 4) {
                System.out.println(text);
            } else {
                System.out.println("TELNET | " + text);
            }
        } else if (type == 5) {
            System.out.println("TELNET | " + text);
        }
    }

    private boolean isValidIP(Socket client) {
        boolean result = false;
        InetAddress ClientIP = client.getInetAddress();
        String clientStringIP = ClientIP.getHostAddress();
        this.telnetOutput(1, "Connection from: " + clientStringIP);
        if (Configuration.general().developer()) {
            this.telnetOutput(2, "");
        }
        for (String host : Configuration.telnet().getHosts()) {
            try {
                String ipToCompare = InetAddress.getByName(host).getHostAddress();
                if (clientStringIP.equals(ipToCompare)) {
                    result = true;
                }
                if (!Configuration.general().debug()) continue;
                this.telnetOutput(3, clientStringIP + " = " + ipToCompare + "(" + host + ") = " + result);
            }
            catch (Exception ex) {
                LOG.warn("There has been an error parsing host {}!", (Object)host, (Object)ex);
            }
        }
        if (Configuration.general().developer()) {
            this.telnetOutput(4, "Allow IP: " + result);
        }
        return result;
    }

    public GameStatusThread(Socket client, int uptime, String StatusPW) throws IOException {
        this.setPriority(10);
        this._cSocket = client;
        this._uptime = uptime;
        this._print = new PrintWriter(this._cSocket.getOutputStream());
        this._read = new BufferedReader(new InputStreamReader(this._cSocket.getInputStream()));
        if (this.isValidIP(client)) {
            this.telnetOutput(1, client.getInetAddress().getHostAddress() + " accepted.");
            this._print.println("Welcome To The L2J Telnet Session.");
            this._print.println("Please Insert Your Password!");
            this._print.print("Password: ");
            this._print.flush();
            String tmpLine = this._read.readLine();
            if (tmpLine == null) {
                this._print.println("Error.");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else if (!tmpLine.equals(StatusPW)) {
                this._print.println("Incorrect Password!");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else {
                this._print.println("Password Correct!");
                this._print.println("[L2J Game Server]");
                this._print.print("");
                this._print.flush();
                this.start();
            }
        } else {
            this.telnetOutput(5, "Connection attempt from " + client.getInetAddress().getHostAddress() + " rejected.");
            this._cSocket.close();
        }
    }

    @Override
    public void run() {
        String _usrCommand = "";
        try {
            while (_usrCommand.compareTo("quit") != 0 && _usrCommand.compareTo("exit") != 0) {
                _usrCommand = this._read.readLine();
                if (_usrCommand == null) {
                    this._cSocket.close();
                    break;
                }
                ITelnetHandler handler = TelnetHandler.getInstance().getHandler(_usrCommand);
                if (handler != null) {
                    handler.useCommand(_usrCommand, this._print, this._cSocket, this._uptime);
                } else if (!(_usrCommand.equalsIgnoreCase("quit") || _usrCommand.equalsIgnoreCase("exit") || _usrCommand.isEmpty())) {
                    this._print.print("Command: " + _usrCommand + " was not found!");
                }
                this._print.print("");
                this._print.flush();
            }
            if (!this._cSocket.isClosed()) {
                this._print.println("Bye Bye!");
                this._print.flush();
                this._cSocket.close();
            }
            this.telnetOutput(1, "Connection from " + this._cSocket.getInetAddress().getHostAddress() + " was closed by client.");
        }
        catch (Exception ex) {
            LOG.warn("There has been an error executing game status task!", ex);
        }
    }
}

