/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import com.l2jserver.gameserver.taskmanager.tasks.TaskBirthday;
import com.l2jserver.gameserver.taskmanager.tasks.TaskClanLeaderApply;
import com.l2jserver.gameserver.taskmanager.tasks.TaskCleanUp;
import com.l2jserver.gameserver.taskmanager.tasks.TaskDailySkillReuseClean;
import com.l2jserver.gameserver.taskmanager.tasks.TaskGlobalVariablesSave;
import com.l2jserver.gameserver.taskmanager.tasks.TaskHuntingSystem;
import com.l2jserver.gameserver.taskmanager.tasks.TaskOlympiadSave;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRaidPointsReset;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRecom;
import com.l2jserver.gameserver.taskmanager.tasks.TaskRestart;
import com.l2jserver.gameserver.taskmanager.tasks.TaskScript;
import com.l2jserver.gameserver.taskmanager.tasks.TaskSevenSignsUpdate;
import com.l2jserver.gameserver.taskmanager.tasks.TaskShutdown;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManager.class);
    private final Map<Integer, Task> _tasks = new ConcurrentHashMap<Integer, Task>();
    protected final List<ExecutedTask> _currentTasks = new CopyOnWriteArrayList<ExecutedTask>();
    protected static final String[] SQL_STATEMENTS = new String[]{"SELECT id,task,type,last_activation,param1,param2,param3 FROM global_tasks", "UPDATE global_tasks SET last_activation=? WHERE id=?", "SELECT id FROM global_tasks WHERE task=?", "INSERT INTO global_tasks (task,type,last_activation,param1,param2,param3) VALUES(?,?,?,?,?,?)"};

    protected TaskManager() {
        this.initializate();
        this.startAllTasks();
        LOG.info("Loaded {} tasks.", (Object)this._tasks.size());
    }

    private void initializate() {
        this.registerTask(new TaskBirthday());
        this.registerTask(new TaskClanLeaderApply());
        this.registerTask(new TaskCleanUp());
        this.registerTask(new TaskDailySkillReuseClean());
        this.registerTask(new TaskGlobalVariablesSave());
        this.registerTask(new TaskHuntingSystem());
        this.registerTask(new TaskOlympiadSave());
        this.registerTask(new TaskRaidPointsReset());
        this.registerTask(new TaskRecom());
        this.registerTask(new TaskRestart());
        this.registerTask(new TaskScript());
        this.registerTask(new TaskSevenSignsUpdate());
        this.registerTask(new TaskShutdown());
    }

    public void registerTask(Task task) {
        int key = task.getName().hashCode();
        this._tasks.computeIfAbsent(key, k -> {
            task.initializate();
            return task;
        });
    }

    private void startAllTasks() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement statement = con.prepareStatement(SQL_STATEMENTS[0]);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                ExecutedTask current;
                TaskTypes type;
                Task task = this._tasks.get(rs.getString("task").trim().toLowerCase().hashCode());
                if (task == null || (type = TaskTypes.valueOf(rs.getString("type"))) == TaskTypes.TYPE_NONE || !this.launchTask(current = new ExecutedTask(task, type, rs))) continue;
                this._currentTasks.add(current);
            }
        }
        catch (Exception ex) {
            LOG.warn("There has been an error while loading global task table!", ex);
        }
    }

    private boolean launchTask(ExecutedTask task) {
        ThreadPoolManager scheduler = ThreadPoolManager.getInstance();
        TaskTypes type = task.getType();
        switch (type) {
            case TYPE_STARTUP: {
                task.run();
                return false;
            }
            case TYPE_SHEDULED: {
                long delay = Long.parseLong(task.getParams()[0]);
                task.scheduled = scheduler.scheduleGeneral(task, delay);
                return true;
            }
            case TYPE_FIXED_SHEDULED: {
                long delay = Long.parseLong(task.getParams()[0]);
                long interval = Long.parseLong(task.getParams()[1]);
                task.scheduled = scheduler.scheduleGeneralAtFixedRate(task, delay, interval);
                return true;
            }
            case TYPE_TIME: {
                try {
                    Date desired = DateFormat.getInstance().parse(task.getParams()[0]);
                    long diff = desired.getTime() - System.currentTimeMillis();
                    if (diff >= 0L) {
                        task.scheduled = scheduler.scheduleGeneral(task, diff);
                        return true;
                    }
                    LOG.info("Task {} is due.", (Object)task.getId());
                }
                catch (Exception desired) {}
                break;
            }
            case TYPE_SPECIAL: {
                ScheduledFuture<?> result = task.getTask().launchSpecial(task);
                if (result == null) break;
                task.scheduled = result;
                return true;
            }
            case TYPE_GLOBAL_TASK: {
                long interval = TimeUnit.DAYS.toMillis(Long.parseLong(task.getParams()[0]));
                String[] hour = task.getParams()[1].split(":");
                if (hour.length != 3) {
                    LOG.warn("Task {} has incorrect parameters!", (Object)task.getId());
                    return false;
                }
                Calendar check = Calendar.getInstance();
                check.setTimeInMillis(task.getLastActivation() + interval);
                Calendar min = Calendar.getInstance();
                try {
                    min.set(11, Integer.parseInt(hour[0]));
                    min.set(12, Integer.parseInt(hour[1]));
                    min.set(13, Integer.parseInt(hour[2]));
                }
                catch (Exception ex) {
                    LOG.warn("Bad parameter on task Id {}!", (Object)task.getId(), (Object)ex);
                    return false;
                }
                long delay = min.getTimeInMillis() - System.currentTimeMillis();
                if (check.after(min) || delay < 0L) {
                    delay += interval;
                }
                task.scheduled = scheduler.scheduleGeneralAtFixedRate(task, delay, interval);
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static boolean addUniqueTask(String task, TaskTypes type, String param1, String param2, String param3) {
        return TaskManager.addUniqueTask(task, type, param1, param2, param3, 0L);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean addUniqueTask(String task, TaskTypes type, String param1, String param2, String param3, long lastActivation) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            boolean bl;
            block27: {
                PreparedStatement ps1 = con.prepareStatement(SQL_STATEMENTS[2]);
                try {
                    block26: {
                        ps1.setString(1, task);
                        try (ResultSet rs = ps1.executeQuery();){
                            if (rs.next()) break block26;
                            try (PreparedStatement ps2 = con.prepareStatement(SQL_STATEMENTS[3]);){
                                ps2.setString(1, task);
                                ps2.setString(2, type.toString());
                                ps2.setLong(3, lastActivation);
                                ps2.setString(4, param1);
                                ps2.setString(5, param2);
                                ps2.setString(6, param3);
                                ps2.execute();
                            }
                        }
                    }
                    bl = true;
                    if (ps1 == null) break block27;
                }
                catch (Throwable throwable) {
                    if (ps1 != null) {
                        try {
                            ps1.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps1.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            LOG.warn("Cannot add the unique task!", ex);
            return false;
        }
    }

    public static boolean addTask(String task, TaskTypes type, String param1, String param2, String param3) {
        return TaskManager.addTask(task, type, param1, param2, param3, 0L);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean addTask(String task, TaskTypes type, String param1, String param2, String param3, long lastActivation) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = con.prepareStatement(SQL_STATEMENTS[3]);
                try {
                    statement.setString(1, task);
                    statement.setString(2, type.toString());
                    statement.setLong(3, lastActivation);
                    statement.setString(4, param1);
                    statement.setString(5, param2);
                    statement.setString(6, param3);
                    statement.execute();
                    bl = true;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException ex) {
            LOG.warn("Cannot add the task {}!", (Object)task, (Object)ex);
            return false;
        }
    }

    public static TaskManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public class ExecutedTask
    implements Runnable {
        int id;
        long lastActivation;
        Task task;
        TaskTypes type;
        String[] params;
        ScheduledFuture<?> scheduled;

        public ExecutedTask(Task ptask, TaskTypes ptype, ResultSet rset) throws SQLException {
            this.task = ptask;
            this.type = ptype;
            this.id = rset.getInt("id");
            this.lastActivation = rset.getLong("last_activation");
            this.params = new String[]{rset.getString("param1"), rset.getString("param2"), rset.getString("param3")};
        }

        @Override
        public void run() {
            this.task.onTimeElapsed(this);
            this.lastActivation = System.currentTimeMillis();
            try (Connection con = ConnectionFactory.getInstance().getConnection();
                 PreparedStatement statement = con.prepareStatement(SQL_STATEMENTS[1]);){
                statement.setLong(1, this.lastActivation);
                statement.setInt(2, this.id);
                statement.executeUpdate();
            }
            catch (SQLException ex) {
                LOG.warn("Cannot updated global task Id {}!", (Object)this.id, (Object)ex);
            }
            if (this.type == TaskTypes.TYPE_SHEDULED || this.type == TaskTypes.TYPE_TIME) {
                this.stopTask();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ExecutedTask)) {
                return false;
            }
            return this.id == ((ExecutedTask)object).id;
        }

        public int hashCode() {
            return this.id;
        }

        public Task getTask() {
            return this.task;
        }

        public TaskTypes getType() {
            return this.type;
        }

        public int getId() {
            return this.id;
        }

        public String[] getParams() {
            return this.params;
        }

        public long getLastActivation() {
            return this.lastActivation;
        }

        public void stopTask() {
            this.task.onDestroy();
            if (this.scheduled != null) {
                this.scheduled.cancel(true);
            }
            TaskManager.this._currentTasks.remove(this);
        }
    }

    private static class SingletonHolder {
        protected static final TaskManager INSTANCE = new TaskManager();

        private SingletonHolder() {
        }
    }
}

