/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.commons.util.Util;
import com.l2jserver.gameserver.config.Configuration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GMAudit {
    private static final Logger LOG = LoggerFactory.getLogger(GMAudit.class);

    public static void auditGMAction(String gmName, String action, String target, String params) {
        SimpleDateFormat _formatter = new SimpleDateFormat("dd/MM/yyyy H:mm:ss");
        String date = _formatter.format(new Date());
        Object name = Util.replaceIllegalCharacters((String)gmName);
        if (!Util.isValidFileName((String)name)) {
            name = "INVALID_GM_NAME_" + date;
        }
        File file = new File("log/GMAudit/" + (String)name + ".txt");
        try (FileWriter save = new FileWriter(file, true);){
            save.write(date + ">" + gmName + ">" + action + ">" + target + ">" + params + Configuration.EOL);
        }
        catch (IOException e) {
            LOG.error("GMAudit for GM {} could not be saved: ", (Object)gmName, (Object)e);
        }
    }

    public static void auditGMAction(String gmName, String action, String target) {
        GMAudit.auditGMAction(gmName, action, target, "");
    }

    static {
        new File("log/GMAudit").mkdirs();
    }
}

