/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.util.file.filter.XMLFilter;
import java.io.File;
import java.io.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public interface IXmlReader {
    public static final Logger LOG = LoggerFactory.getLogger(IXmlReader.class);
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final XMLFilter XML_FILTER = new XMLFilter();

    public void load();

    default public void parseDatapackFile(String path) {
        this.parseFile(new File(Configuration.server().getDatapackRoot(), path));
    }

    default public void parseFile(File f) {
        if (!this.getCurrentFileFilter().accept(f)) {
            LOG.warn("{}: Could not parse {} is not a file or it doesn't exist!", (Object)this.getClass().getSimpleName(), (Object)f.getName());
            return;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setIgnoringComments(true);
        try {
            dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new XMLErrorHandler());
            this.parseDocument(db.parse(f), f);
        }
        catch (SAXParseException e) {
            LOG.warn("{}: Could not parse file {} at line {}, column {}", this.getClass().getSimpleName(), f.getName(), e.getLineNumber(), e.getColumnNumber(), e);
        }
        catch (Exception e) {
            LOG.warn("{}: Could not parse file {}", this.getClass().getSimpleName(), f.getName(), e);
        }
    }

    default public boolean parseDirectory(File dir, boolean recursive) {
        if (!dir.exists()) {
            LOG.warn("{}: Folder {} doesn't exist!", (Object)this.getClass().getSimpleName(), (Object)dir.getAbsolutePath());
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (recursive && file.isDirectory()) {
                    this.parseDirectory(file, recursive);
                    continue;
                }
                if (!this.getCurrentFileFilter().accept(file)) continue;
                this.parseFile(file);
            }
        }
        return true;
    }

    default public boolean parseDatapackDirectory(String path, boolean recursive) {
        return this.parseDirectory(new File(Configuration.server().getDatapackRoot(), path), recursive);
    }

    default public void parseDocument(Document doc, File f) {
        this.parseDocument(doc);
    }

    default public void parseDocument(Document doc) {
        LOG.error("{}: Parser not implemented!", (Object)this.getClass().getSimpleName());
    }

    default public Boolean parseBoolean(Node node, Boolean defaultValue) {
        return node != null ? Boolean.valueOf(node.getNodeValue()) : defaultValue;
    }

    default public Boolean parseBoolean(Node node) {
        return this.parseBoolean(node, null);
    }

    default public Boolean parseBoolean(NamedNodeMap attrs, String name) {
        return this.parseBoolean(attrs.getNamedItem(name));
    }

    default public Boolean parseBoolean(NamedNodeMap attrs, String name, Boolean defaultValue) {
        return this.parseBoolean(attrs.getNamedItem(name), defaultValue);
    }

    default public Byte parseByte(Node node, Byte defaultValue) {
        return node != null ? Byte.valueOf(node.getNodeValue()) : defaultValue;
    }

    default public Byte parseByte(Node node) {
        return this.parseByte(node, null);
    }

    default public Byte parseByte(NamedNodeMap attrs, String name) {
        return this.parseByte(attrs.getNamedItem(name));
    }

    default public Byte parseByte(NamedNodeMap attrs, String name, Byte defaultValue) {
        return this.parseByte(attrs.getNamedItem(name), defaultValue);
    }

    default public Short parseShort(Node node, Short defaultValue) {
        return node != null ? Short.valueOf(node.getNodeValue()) : defaultValue;
    }

    default public Short parseShort(Node node) {
        return this.parseShort(node, null);
    }

    default public Short parseShort(NamedNodeMap attrs, String name) {
        return this.parseShort(attrs.getNamedItem(name));
    }

    default public Short parseShort(NamedNodeMap attrs, String name, Short defaultValue) {
        return this.parseShort(attrs.getNamedItem(name), defaultValue);
    }

    default public int parseInt(Node node, Integer defaultValue) {
        return node != null ? Integer.parseInt(node.getNodeValue()) : defaultValue;
    }

    default public int parseInt(Node node) {
        return this.parseInt(node, -1);
    }

    default public Integer parseInteger(Node node, Integer defaultValue) {
        return node != null ? Integer.valueOf(node.getNodeValue()) : defaultValue;
    }

    default public Integer parseInteger(Node node) {
        return this.parseInteger(node, null);
    }

    default public Integer parseInteger(NamedNodeMap attrs, String name) {
        return this.parseInteger(attrs.getNamedItem(name));
    }

    default public Integer parseInteger(NamedNodeMap attrs, String name, Integer defaultValue) {
        return this.parseInteger(attrs.getNamedItem(name), defaultValue);
    }

    default public Long parseLong(Node node, Long defaultValue) {
        return node != null ? Long.valueOf(node.getNodeValue()) : defaultValue;
    }

    default public Long parseLong(Node node) {
        return this.parseLong(node, null);
    }

    default public Long parseLong(NamedNodeMap attrs, String name) {
        return this.parseLong(attrs.getNamedItem(name));
    }

    default public Long parseLong(NamedNodeMap attrs, String name, Long defaultValue) {
        return this.parseLong(attrs.getNamedItem(name), defaultValue);
    }

    default public Float parseFloat(Node node, Float defaultValue) {
        return node != null ? Float.valueOf(node.getNodeValue()) : defaultValue;
    }

    default public Float parseFloat(Node node) {
        return this.parseFloat(node, null);
    }

    default public Float parseFloat(NamedNodeMap attrs, String name) {
        return this.parseFloat(attrs.getNamedItem(name));
    }

    default public Float parseFloat(NamedNodeMap attrs, String name, Float defaultValue) {
        return this.parseFloat(attrs.getNamedItem(name), defaultValue);
    }

    default public Double parseDouble(Node node, Double defaultValue) {
        return node != null ? Double.valueOf(node.getNodeValue()) : defaultValue;
    }

    default public Double parseDouble(Node node) {
        return this.parseDouble(node, null);
    }

    default public Double parseDouble(NamedNodeMap attrs, String name) {
        return this.parseDouble(attrs.getNamedItem(name));
    }

    default public Double parseDouble(NamedNodeMap attrs, String name, Double defaultValue) {
        return this.parseDouble(attrs.getNamedItem(name), defaultValue);
    }

    default public String parseString(Node node, String defaultValue) {
        return node != null ? node.getNodeValue() : defaultValue;
    }

    default public String parseString(Node node) {
        return this.parseString(node, null);
    }

    default public String parseString(NamedNodeMap attrs, String name) {
        return this.parseString(attrs.getNamedItem(name));
    }

    default public String parseString(NamedNodeMap attrs, String name, String defaultValue) {
        return this.parseString(attrs.getNamedItem(name), defaultValue);
    }

    default public <T extends Enum<T>> T parseEnum(Node node, Class<T> clazz, T defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, node.getNodeValue());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid value specified for node: {} specified value: {} should be enum value of \"{}\" using default value: {}", node.getNodeName(), node.getNodeValue(), clazz.getSimpleName(), defaultValue);
            return defaultValue;
        }
    }

    default public <T extends Enum<T>> T parseEnum(Node node, Class<T> clazz) {
        return this.parseEnum(node, clazz, null);
    }

    default public <T extends Enum<T>> T parseEnum(NamedNodeMap attrs, Class<T> clazz, String name) {
        return this.parseEnum(attrs.getNamedItem(name), clazz);
    }

    default public <T extends Enum<T>> T parseEnum(NamedNodeMap attrs, Class<T> clazz, String name, T defaultValue) {
        return this.parseEnum(attrs.getNamedItem(name), clazz, defaultValue);
    }

    default public FileFilter getCurrentFileFilter() {
        return XML_FILTER;
    }

    public static class XMLErrorHandler
    implements ErrorHandler {
        @Override
        public void warning(SAXParseException e) throws SAXParseException {
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXParseException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXParseException {
            throw e;
        }
    }
}

