/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid.internal;

import com.google.crypto.tink.aead.internal.InsecureNonceChaCha20Poly1305;
import com.google.crypto.tink.aead.internal.InsecureNonceChaCha20Poly1305Jce;
import com.google.crypto.tink.hybrid.internal.HpkeAead;
import com.google.crypto.tink.hybrid.internal.HpkeUtil;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;

@Immutable
final class ChaCha20Poly1305HpkeAead
implements HpkeAead {
    ChaCha20Poly1305HpkeAead() {
    }

    @Override
    public byte[] seal(byte[] key, byte[] nonce, byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        if (key.length != this.getKeyLength()) {
            throw new InvalidAlgorithmParameterException("Unexpected key length: " + this.getKeyLength());
        }
        if (InsecureNonceChaCha20Poly1305Jce.isSupported()) {
            InsecureNonceChaCha20Poly1305Jce aead = InsecureNonceChaCha20Poly1305Jce.create(key);
            return aead.encrypt(nonce, plaintext, associatedData);
        }
        InsecureNonceChaCha20Poly1305 aead = new InsecureNonceChaCha20Poly1305(key);
        return aead.encrypt(nonce, plaintext, associatedData);
    }

    @Override
    public byte[] open(byte[] key, byte[] nonce, byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        if (key.length != this.getKeyLength()) {
            throw new InvalidAlgorithmParameterException("Unexpected key length: " + this.getKeyLength());
        }
        if (InsecureNonceChaCha20Poly1305Jce.isSupported()) {
            InsecureNonceChaCha20Poly1305Jce aead = InsecureNonceChaCha20Poly1305Jce.create(key);
            return aead.decrypt(nonce, ciphertext, associatedData);
        }
        InsecureNonceChaCha20Poly1305 aead = new InsecureNonceChaCha20Poly1305(key);
        return aead.decrypt(nonce, ciphertext, associatedData);
    }

    @Override
    public byte[] getAeadId() {
        return HpkeUtil.CHACHA20_POLY1305_AEAD_ID;
    }

    @Override
    public int getKeyLength() {
        return 32;
    }

    @Override
    public int getNonceLength() {
        return 12;
    }
}

