/*
 * Decompiled with CFR 0.152.
 */
package org.aeonbits.owner.loaders;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.aeonbits.owner.loaders.Loader;
import org.aeonbits.owner.util.Util;

public class SystemLoader
implements Loader {
    private static final String SYSTEM_PROPERTIES_URI = "system:properties";
    private static final String ENVIRONMENT_VARIABLES_URI = "system:env";

    @Override
    public boolean accept(URI uri) {
        String path = uri.toString();
        return SYSTEM_PROPERTIES_URI.equals(path) || ENVIRONMENT_VARIABLES_URI.equals(path);
    }

    @Override
    public void load(Properties result, URI uri) throws IOException {
        String path = uri.toString();
        if (SYSTEM_PROPERTIES_URI.equals(path)) {
            result.putAll((Map<?, ?>)Util.system().getProperties());
        }
        if (ENVIRONMENT_VARIABLES_URI.equals(path)) {
            result.putAll(Util.system().getenv());
        }
    }

    @Override
    public String defaultSpecFor(String uriPrefix) {
        return null;
    }
}

