/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.entity.Fort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FortUpdater
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(FortUpdater.class);
    private final L2Clan _clan;
    private final Fort _fort;
    private int _runCount;
    private final UpdaterType _updaterType;

    public FortUpdater(Fort fort, L2Clan clan, int runCount, UpdaterType ut) {
        this._fort = fort;
        this._clan = clan;
        this._runCount = runCount;
        this._updaterType = ut;
    }

    @Override
    public void run() {
        try {
            switch (this._updaterType.ordinal()) {
                case 1: {
                    ++this._runCount;
                    if (this._fort.getOwnerClan() == null || this._fort.getOwnerClan() != this._clan) {
                        return;
                    }
                    this._fort.getOwnerClan().increaseBloodOathCount();
                    if (this._fort.getFortState() == 2) {
                        if (this._clan.getWarehouse().getAdena() >= (long)Configuration.fortress().getFeeForCastle()) {
                            this._clan.getWarehouse().destroyItemByItemId("FS_fee_for_Castle", 57, Configuration.fortress().getFeeForCastle(), null, null);
                            this._fort.getContractedCastle().addToTreasuryNoTax(Configuration.fortress().getFeeForCastle());
                            this._fort.raiseSupplyLvL();
                        } else {
                            this._fort.setFortState(1, 0);
                        }
                    }
                    this._fort.saveFortVariables();
                    break;
                }
                case 0: {
                    if (this._fort.getOwnerClan() == null || this._fort.getOwnerClan() != this._clan) {
                        return;
                    }
                    if (this._fort.getOwnedTime() <= Configuration.fortress().getMaxKeepTime() * 3600) break;
                    this._fort.removeOwner(true);
                    this._fort.setFortState(0, 0);
                }
            }
        }
        catch (Exception e) {
            LOG.error("There has been a problem updating forts!", e);
        }
    }

    public int getRunCount() {
        return this._runCount;
    }

    public static enum UpdaterType {
        MAX_OWN_TIME,
        PERIODIC_UPDATE;

    }
}

