/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.data.xml.impl.NpcData;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonsterRace {
    protected static final Logger LOG = LoggerFactory.getLogger(MonsterRace.class);
    private final L2Npc[] _monsters = new L2Npc[8];
    private int[][] _speeds = new int[8][20];
    private final int[] _first = new int[2];
    private final int[] _second = new int[2];

    protected MonsterRace() {
    }

    public static MonsterRace getInstance() {
        return SingletonHolder._instance;
    }

    public void newRace() {
        for (int i = 0; i < 8; ++i) {
            int id = 31003;
            int random = Rnd.get((int)24);
            for (int j = i - 1; j >= 0; --j) {
                if (this._monsters[j].getTemplate().getId() != id + random) continue;
                random = Rnd.get((int)24);
            }
            try {
                int objectId = IdFactory.getInstance().getNextId();
                L2NpcTemplate template = NpcData.getInstance().getTemplate(id + random);
                Constructor<?> constructor = Class.forName("com.l2jserver.gameserver.model.actor.instance." + template.getType() + "Instance").getConstructors()[0];
                this._monsters[i] = (L2Npc)constructor.newInstance(objectId, template);
                continue;
            }
            catch (Exception e) {
                LOG.warn("Unable to create monster!", e);
            }
        }
        this.newSpeeds();
    }

    public void newSpeeds() {
        this._speeds = new int[8][20];
        this._first[1] = 0;
        this._second[1] = 0;
        for (int i = 0; i < 8; ++i) {
            int total = 0;
            for (int j = 0; j < 20; ++j) {
                this._speeds[i][j] = j == 19 ? 100 : Rnd.get((int)60) + 65;
                total += this._speeds[i][j];
            }
            if (total >= this._first[1]) {
                this._second[0] = this._first[0];
                this._second[1] = this._first[1];
                this._first[0] = 8 - i;
                this._first[1] = total;
                continue;
            }
            if (total < this._second[1]) continue;
            this._second[0] = 8 - i;
            this._second[1] = total;
        }
    }

    public L2Npc[] getMonsters() {
        return this._monsters;
    }

    public int[][] getSpeeds() {
        return this._speeds;
    }

    public int getFirstPlace() {
        return this._first[0];
    }

    public int getSecondPlace() {
        return this._second[0];
    }

    private static class SingletonHolder {
        protected static final MonsterRace _instance = new MonsterRace();

        private SingletonHolder() {
        }
    }
}

