/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolManager {
    protected static final Logger LOG = LoggerFactory.getLogger(ThreadPoolManager.class);
    private final ScheduledThreadPoolExecutor _effectsScheduledThreadPool = new ScheduledThreadPoolExecutor(Configuration.general().getThreadPoolSizeEffects(), new PriorityThreadFactory("EffectsSTPool", 5));
    private final ScheduledThreadPoolExecutor _generalScheduledThreadPool = new ScheduledThreadPoolExecutor(Configuration.general().getThreadPoolSizeGeneral(), new PriorityThreadFactory("GeneralSTPool", 5));
    private final ScheduledThreadPoolExecutor _aiScheduledThreadPool;
    private final ScheduledThreadPoolExecutor _eventScheduledThreadPool = new ScheduledThreadPoolExecutor(Configuration.general().getThreadPoolSizeEvents(), new PriorityThreadFactory("EventSTPool", 5));
    private final ThreadPoolExecutor _generalPacketsThreadPool;
    private final ThreadPoolExecutor _ioPacketsThreadPool = new ThreadPoolExecutor(Configuration.general().getUrgentPacketThreadCoreSize(), Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory("I/O Packet Pool", 6));
    private final ThreadPoolExecutor _generalThreadPool;
    private final ThreadPoolExecutor _eventThreadPool;
    private boolean _shutdown;

    public static ThreadPoolManager getInstance() {
        return SingletonHolder._instance;
    }

    protected ThreadPoolManager() {
        this._generalPacketsThreadPool = new ThreadPoolExecutor(Configuration.general().getGeneralPacketThreadCoreSize(), Configuration.general().getGeneralPacketThreadCoreSize() + 2, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory("Normal Packet Pool", 6));
        this._generalThreadPool = new ThreadPoolExecutor(Configuration.general().getGeneralThreadCoreSize(), Configuration.general().getGeneralThreadCoreSize() + 2, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory("General Pool", 5));
        this._aiScheduledThreadPool = new ScheduledThreadPoolExecutor(Configuration.general().getAiMaxThread(), new PriorityThreadFactory("AISTPool", 5));
        this._eventThreadPool = new ThreadPoolExecutor(Configuration.general().getEventsMaxThread(), Configuration.general().getEventsMaxThread() + 2, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory("Event Pool", 5));
        this.scheduleGeneralAtFixedRate(new PurgeTask(this._effectsScheduledThreadPool, this._generalScheduledThreadPool, this._aiScheduledThreadPool, this._eventThreadPool), 10L, 5L, TimeUnit.MINUTES);
    }

    public ScheduledFuture<?> scheduleEffect(Runnable task, long delay, TimeUnit unit) {
        try {
            return this._effectsScheduledThreadPool.schedule(new RunnableWrapper(task), delay, unit);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleEffect(Runnable task, long delay) {
        return this.scheduleEffect(task, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleEffectAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        try {
            return this._effectsScheduledThreadPool.scheduleAtFixedRate(new RunnableWrapper(task), initialDelay, period, unit);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleEffectAtFixedRate(Runnable task, long initialDelay, long period) {
        return this.scheduleEffectAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleGeneral(Runnable task, long delay, TimeUnit unit) {
        try {
            return this._generalScheduledThreadPool.schedule(new RunnableWrapper(task), delay, unit);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleGeneral(Runnable task, long delay) {
        return this.scheduleGeneral(task, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleGeneralAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        try {
            return this._generalScheduledThreadPool.scheduleAtFixedRate(new RunnableWrapper(task), initialDelay, period, unit);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleEvent(Runnable task, long delay, TimeUnit unit) {
        try {
            return this._eventScheduledThreadPool.schedule(new RunnableWrapper(task), delay, unit);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleEvent(Runnable task, long delay) {
        return this.scheduleEvent(task, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleEventAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        try {
            return this._eventScheduledThreadPool.scheduleAtFixedRate(new RunnableWrapper(task), initialDelay, period, unit);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleGeneralAtFixedRate(Runnable task, long initialDelay, long period) {
        return this.scheduleGeneralAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleAi(Runnable task, long delay, TimeUnit unit) {
        try {
            return this._aiScheduledThreadPool.schedule(new RunnableWrapper(task), delay, unit);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleAi(Runnable task, long delay) {
        return this.scheduleAi(task, delay, TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> scheduleAiAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        try {
            return this._aiScheduledThreadPool.scheduleAtFixedRate(new RunnableWrapper(task), initialDelay, period, unit);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleAiAtFixedRate(Runnable task, long initialDelay, long period) {
        return this.scheduleAiAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public void executePacket(Runnable task) {
        try {
            this._generalPacketsThreadPool.execute(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void executeIOPacket(Runnable task) {
        try {
            this._ioPacketsThreadPool.execute(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void executeGeneral(Runnable task) {
        try {
            this._generalThreadPool.execute(new RunnableWrapper(task));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void executeAi(Runnable task) {
        try {
            this._aiScheduledThreadPool.execute(new RunnableWrapper(task));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void executeEvent(Runnable task) {
        try {
            this._eventThreadPool.execute(new RunnableWrapper(task));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public String[] getStats() {
        return new String[]{"STP:", " + Effects:", " |- ActiveThreads:   " + this._effectsScheduledThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._effectsScheduledThreadPool.getCorePoolSize(), " |- PoolSize:        " + this._effectsScheduledThreadPool.getPoolSize(), " |- MaximumPoolSize: " + this._effectsScheduledThreadPool.getMaximumPoolSize(), " |- CompletedTasks:  " + this._effectsScheduledThreadPool.getCompletedTaskCount(), " |- ScheduledTasks:  " + this._effectsScheduledThreadPool.getQueue().size(), " | -------", " + General:", " |- ActiveThreads:   " + this._generalScheduledThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._generalScheduledThreadPool.getCorePoolSize(), " |- PoolSize:        " + this._generalScheduledThreadPool.getPoolSize(), " |- MaximumPoolSize: " + this._generalScheduledThreadPool.getMaximumPoolSize(), " |- CompletedTasks:  " + this._generalScheduledThreadPool.getCompletedTaskCount(), " |- ScheduledTasks:  " + this._generalScheduledThreadPool.getQueue().size(), " | -------", " + AI:", " |- ActiveThreads:   " + this._aiScheduledThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._aiScheduledThreadPool.getCorePoolSize(), " |- PoolSize:        " + this._aiScheduledThreadPool.getPoolSize(), " |- MaximumPoolSize: " + this._aiScheduledThreadPool.getMaximumPoolSize(), " |- CompletedTasks:  " + this._aiScheduledThreadPool.getCompletedTaskCount(), " |- ScheduledTasks:  " + this._aiScheduledThreadPool.getQueue().size(), " | -------", " + Event:", " |- ActiveThreads:   " + this._eventScheduledThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._eventScheduledThreadPool.getCorePoolSize(), " |- PoolSize:        " + this._eventScheduledThreadPool.getPoolSize(), " |- MaximumPoolSize: " + this._eventScheduledThreadPool.getMaximumPoolSize(), " |- CompletedTasks:  " + this._eventScheduledThreadPool.getCompletedTaskCount(), " |- ScheduledTasks:  " + this._eventScheduledThreadPool.getQueue().size(), "TP:", " + Packets:", " |- ActiveThreads:   " + this._generalPacketsThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._generalPacketsThreadPool.getCorePoolSize(), " |- MaximumPoolSize: " + this._generalPacketsThreadPool.getMaximumPoolSize(), " |- LargestPoolSize: " + this._generalPacketsThreadPool.getLargestPoolSize(), " |- PoolSize:        " + this._generalPacketsThreadPool.getPoolSize(), " |- CompletedTasks:  " + this._generalPacketsThreadPool.getCompletedTaskCount(), " |- QueuedTasks:     " + this._generalPacketsThreadPool.getQueue().size(), " | -------", " + I/O Packets:", " |- ActiveThreads:   " + this._ioPacketsThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._ioPacketsThreadPool.getCorePoolSize(), " |- MaximumPoolSize: " + this._ioPacketsThreadPool.getMaximumPoolSize(), " |- LargestPoolSize: " + this._ioPacketsThreadPool.getLargestPoolSize(), " |- PoolSize:        " + this._ioPacketsThreadPool.getPoolSize(), " |- CompletedTasks:  " + this._ioPacketsThreadPool.getCompletedTaskCount(), " |- QueuedTasks:     " + this._ioPacketsThreadPool.getQueue().size(), " | -------", " + General Tasks:", " |- ActiveThreads:   " + this._generalThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._generalThreadPool.getCorePoolSize(), " |- MaximumPoolSize: " + this._generalThreadPool.getMaximumPoolSize(), " |- LargestPoolSize: " + this._generalThreadPool.getLargestPoolSize(), " |- PoolSize:        " + this._generalThreadPool.getPoolSize(), " |- CompletedTasks:  " + this._generalThreadPool.getCompletedTaskCount(), " |- QueuedTasks:     " + this._generalThreadPool.getQueue().size(), " | -------", " + Event Tasks:", " |- ActiveThreads:   " + this._eventThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._eventThreadPool.getCorePoolSize(), " |- MaximumPoolSize: " + this._eventThreadPool.getMaximumPoolSize(), " |- LargestPoolSize: " + this._eventThreadPool.getLargestPoolSize(), " |- PoolSize:        " + this._eventThreadPool.getPoolSize(), " |- CompletedTasks:  " + this._eventThreadPool.getCompletedTaskCount(), " |- QueuedTasks:     " + this._eventThreadPool.getQueue().size(), " | -------"};
    }

    public void shutdown() {
        this._shutdown = true;
        try {
            this._effectsScheduledThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._generalScheduledThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._generalPacketsThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._ioPacketsThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._generalThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._eventThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._effectsScheduledThreadPool.shutdown();
            this._generalScheduledThreadPool.shutdown();
            this._generalPacketsThreadPool.shutdown();
            this._ioPacketsThreadPool.shutdown();
            this._generalThreadPool.shutdown();
            this._eventThreadPool.shutdown();
            LOG.info("All ThreadPools are now stopped");
        }
        catch (InterruptedException e) {
            LOG.warn("There has been a problem shutting down the thread pool manager!", e);
        }
    }

    public boolean isShutdown() {
        return this._shutdown;
    }

    public void purge() {
        this._effectsScheduledThreadPool.purge();
        this._generalScheduledThreadPool.purge();
        this._aiScheduledThreadPool.purge();
        this._eventScheduledThreadPool.purge();
        this._ioPacketsThreadPool.purge();
        this._generalPacketsThreadPool.purge();
        this._generalThreadPool.purge();
        this._eventThreadPool.purge();
    }

    public String getPacketStats() {
        StringBuilder sb = new StringBuilder(1000);
        ThreadFactory tf = this._generalPacketsThreadPool.getThreadFactory();
        if (tf instanceof PriorityThreadFactory) {
            PriorityThreadFactory ptf = (PriorityThreadFactory)tf;
            int count = ptf.getGroup().activeCount();
            Thread[] threads = new Thread[count + 2];
            ptf.getGroup().enumerate(threads);
            StringUtil.append(sb, "General Packet Thread Pool:" + Configuration.EOL + "Tasks in the queue: ", String.valueOf(this._generalPacketsThreadPool.getQueue().size()), Configuration.EOL + "Showing threads stack trace:" + Configuration.EOL + "There should be ", String.valueOf(count), " Threads" + Configuration.EOL);
            for (Thread t : threads) {
                if (t == null) continue;
                StringUtil.append(sb, t.getName(), Configuration.EOL);
                for (StackTraceElement ste : t.getStackTrace()) {
                    StringUtil.append(sb, ste.toString(), Configuration.EOL);
                }
            }
        }
        sb.append("Packet Tp stack traces printed.");
        sb.append(Configuration.EOL);
        return sb.toString();
    }

    public String getIOPacketStats() {
        StringBuilder sb = new StringBuilder(1000);
        ThreadFactory tf = this._ioPacketsThreadPool.getThreadFactory();
        if (tf instanceof PriorityThreadFactory) {
            PriorityThreadFactory ptf = (PriorityThreadFactory)tf;
            int count = ptf.getGroup().activeCount();
            Thread[] threads = new Thread[count + 2];
            ptf.getGroup().enumerate(threads);
            StringUtil.append(sb, "I/O Packet Thread Pool:" + Configuration.EOL + "Tasks in the queue: ", String.valueOf(this._ioPacketsThreadPool.getQueue().size()), Configuration.EOL + "Showing threads stack trace:" + Configuration.EOL + "There should be ", String.valueOf(count), " Threads" + Configuration.EOL);
            for (Thread t : threads) {
                if (t == null) continue;
                StringUtil.append(sb, t.getName(), Configuration.EOL);
                for (StackTraceElement ste : t.getStackTrace()) {
                    StringUtil.append(sb, ste.toString(), Configuration.EOL);
                }
            }
        }
        sb.append("Packet Tp stack traces printed.");
        sb.append(Configuration.EOL);
        return sb.toString();
    }

    public String getGeneralStats() {
        StringBuilder sb = new StringBuilder(1000);
        ThreadFactory tf = this._generalThreadPool.getThreadFactory();
        if (tf instanceof PriorityThreadFactory) {
            PriorityThreadFactory ptf = (PriorityThreadFactory)tf;
            int count = ptf.getGroup().activeCount();
            Thread[] threads = new Thread[count + 2];
            ptf.getGroup().enumerate(threads);
            StringUtil.append(sb, "General Thread Pool:" + Configuration.EOL + "Tasks in the queue: ", String.valueOf(this._generalThreadPool.getQueue().size()), Configuration.EOL + "Showing threads stack trace:" + Configuration.EOL + "There should be ", String.valueOf(count), " Threads" + Configuration.EOL);
            for (Thread t : threads) {
                if (t == null) continue;
                StringUtil.append(sb, t.getName(), Configuration.EOL);
                for (StackTraceElement ste : t.getStackTrace()) {
                    StringUtil.append(sb, ste.toString(), Configuration.EOL);
                }
            }
        }
        sb.append("Packet Tp stack traces printed.");
        sb.append(Configuration.EOL);
        return sb.toString();
    }

    private static class SingletonHolder {
        protected static final ThreadPoolManager _instance = new ThreadPoolManager();

        private SingletonHolder() {
        }
    }

    private static class PriorityThreadFactory
    implements ThreadFactory {
        private final int _priority;
        private final String _name;
        private final AtomicInteger _threadNumber = new AtomicInteger(1);
        private final ThreadGroup _group;

        public PriorityThreadFactory(String name, int priority) {
            this._priority = priority;
            this._name = name;
            this._group = new ThreadGroup(this._name);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this._group, r, this._name + "-" + this._threadNumber.getAndIncrement());
            t.setPriority(this._priority);
            return t;
        }

        public ThreadGroup getGroup() {
            return this._group;
        }
    }

    protected static class PurgeTask
    implements Runnable {
        private final ScheduledThreadPoolExecutor _effectsScheduled;
        private final ScheduledThreadPoolExecutor _generalScheduled;
        private final ScheduledThreadPoolExecutor _aiScheduled;
        private final ThreadPoolExecutor _eventScheduled;

        PurgeTask(ScheduledThreadPoolExecutor effectsScheduledThreadPool, ScheduledThreadPoolExecutor generalScheduledThreadPool, ScheduledThreadPoolExecutor aiScheduledThreadPool, ThreadPoolExecutor eventScheduledThreadPool) {
            this._effectsScheduled = effectsScheduledThreadPool;
            this._generalScheduled = generalScheduledThreadPool;
            this._aiScheduled = aiScheduledThreadPool;
            this._eventScheduled = eventScheduledThreadPool;
        }

        @Override
        public void run() {
            this._effectsScheduled.purge();
            this._generalScheduled.purge();
            this._aiScheduled.purge();
            this._eventScheduled.purge();
        }
    }

    private static final class RunnableWrapper
    implements Runnable {
        private final Runnable _r;

        public RunnableWrapper(Runnable r) {
            this._r = r;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this._r.run();
                }
                catch (Throwable e) {
                    Thread t = Thread.currentThread();
                    Thread.UncaughtExceptionHandler h = t.getUncaughtExceptionHandler();
                    if (h == null) break block2;
                    h.uncaughtException(t, e);
                }
            }
        }
    }
}

