/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.Ctrl;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.NextAction;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.AutoAttackStart;
import com.l2jserver.gameserver.network.serverpackets.AutoAttackStop;
import com.l2jserver.gameserver.network.serverpackets.Die;
import com.l2jserver.gameserver.network.serverpackets.MoveToLocation;
import com.l2jserver.gameserver.network.serverpackets.MoveToPawn;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.StopRotation;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAI
implements Ctrl {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractAI.class);
    private NextAction _nextAction;
    protected final L2Character _actor;
    protected CtrlIntention _intention = CtrlIntention.AI_INTENTION_IDLE;
    protected Object _intentionArg0 = null;
    protected Object _intentionArg1 = null;
    protected volatile boolean _clientMoving;
    protected volatile boolean _clientAutoAttacking;
    protected int _clientMovingToPawnOffset;
    private L2Object _target;
    private L2Character _castTarget;
    protected L2Character _attackTarget;
    protected L2Character _followTarget;
    protected Skill _skill;
    private int _moveToPawnTimeout;
    protected Future<?> _followTask = null;
    private static final int FOLLOW_INTERVAL = 1000;
    private static final int ATTACK_FOLLOW_INTERVAL = 500;

    public NextAction getNextAction() {
        return this._nextAction;
    }

    public void setNextAction(NextAction nextAction) {
        this._nextAction = nextAction;
    }

    protected AbstractAI(L2Character creature) {
        this._actor = creature;
    }

    @Override
    public L2Character getActor() {
        return this._actor;
    }

    @Override
    public CtrlIntention getIntention() {
        return this._intention;
    }

    protected void setCastTarget(L2Character target) {
        this._castTarget = target;
    }

    public L2Character getCastTarget() {
        return this._castTarget;
    }

    protected void setAttackTarget(L2Character target) {
        this._attackTarget = target;
    }

    @Override
    public L2Character getAttackTarget() {
        return this._attackTarget;
    }

    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        this._intention = intention;
        this._intentionArg0 = arg0;
        this._intentionArg1 = arg1;
    }

    @Override
    public final void setIntention(CtrlIntention intention) {
        this.setIntention(intention, null, null);
    }

    @Override
    public final void setIntention(CtrlIntention intention, Object arg0) {
        this.setIntention(intention, arg0, null);
    }

    @Override
    public final void setIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention != CtrlIntention.AI_INTENTION_FOLLOW && intention != CtrlIntention.AI_INTENTION_ATTACK) {
            this.stopFollow();
        }
        switch (intention) {
            case AI_INTENTION_IDLE: {
                this.onIntentionIdle();
                break;
            }
            case AI_INTENTION_ACTIVE: {
                this.onIntentionActive();
                break;
            }
            case AI_INTENTION_REST: {
                this.onIntentionRest();
                break;
            }
            case AI_INTENTION_ATTACK: {
                this.onIntentionAttack((L2Character)arg0);
                break;
            }
            case AI_INTENTION_CAST: {
                this.onIntentionCast((Skill)arg0, (L2Object)arg1);
                break;
            }
            case AI_INTENTION_MOVE_TO: {
                this.onIntentionMoveTo((Location)arg0);
                break;
            }
            case AI_INTENTION_FOLLOW: {
                this.onIntentionFollow((L2Character)arg0);
                break;
            }
            case AI_INTENTION_PICK_UP: {
                this.onIntentionPickUp((L2Object)arg0);
                break;
            }
            case AI_INTENTION_INTERACT: {
                this.onIntentionInteract((L2Object)arg0);
            }
        }
        if (this._nextAction != null && this._nextAction.getIntentions().contains((Object)intention)) {
            this._nextAction = null;
        }
    }

    @Override
    public final void notifyEvent(CtrlEvent evt) {
        this.notifyEvent(evt, null, null);
    }

    @Override
    public final void notifyEvent(CtrlEvent evt, Object arg0) {
        this.notifyEvent(evt, arg0, null);
    }

    @Override
    public final void notifyEvent(CtrlEvent evt, Object ... args) {
        if (!this._actor.isVisible() && !this._actor.isTeleporting() || !this._actor.hasAI()) {
            return;
        }
        switch (evt) {
            case EVT_THINK: {
                this.onEvtThink();
                break;
            }
            case EVT_ATTACKED: {
                this.onEvtAttacked((L2Character)args[0]);
                break;
            }
            case EVT_AGGRESSION: {
                this.onEvtAggression((L2Character)args[0], ((Number)args[1]).intValue());
                break;
            }
            case EVT_STUNNED: {
                this.onEvtStunned((L2Character)args[0]);
                break;
            }
            case EVT_SLEEPING: {
                this.onEvtSleeping((L2Character)args[0]);
                break;
            }
            case EVT_ROOTED: {
                this.onEvtRooted((L2Character)args[0]);
                break;
            }
            case EVT_CONFUSED: {
                this.onEvtConfused((L2Character)args[0]);
                break;
            }
            case EVT_MUTED: {
                this.onEvtMuted((L2Character)args[0]);
                break;
            }
            case EVT_EVADED: {
                this.onEvtEvaded((L2Character)args[0]);
                break;
            }
            case EVT_READY_TO_ACT: {
                if (this._actor.isCastingNow() || this._actor.isCastingSimultaneouslyNow()) break;
                this.onEvtReadyToAct();
                break;
            }
            case EVT_USER_CMD: {
                this.onEvtUserCmd(args[0], args[1]);
                break;
            }
            case EVT_ARRIVED: {
                if (this._actor.isCastingNow() || this._actor.isCastingSimultaneouslyNow()) break;
                this.onEvtArrived();
                break;
            }
            case EVT_ARRIVED_REVALIDATE: {
                if (!this._actor.isMoving()) break;
                this.onEvtArrivedRevalidate();
                break;
            }
            case EVT_ARRIVED_BLOCKED: {
                this.onEvtArrivedBlocked((Location)args[0]);
                break;
            }
            case EVT_FORGET_OBJECT: {
                this.onEvtForgetObject((L2Object)args[0]);
                break;
            }
            case EVT_CANCEL: {
                this.onEvtCancel();
                break;
            }
            case EVT_DEAD: {
                this.onEvtDead();
                break;
            }
            case EVT_FAKE_DEATH: {
                this.onEvtFakeDeath();
                break;
            }
            case EVT_FINISH_CASTING: {
                this.onEvtFinishCasting();
                break;
            }
            case EVT_AFRAID: {
                this.onEvtAfraid((L2Character)args[0], (Boolean)args[1]);
            }
        }
        if (this._nextAction != null && this._nextAction.getEvents().contains((Object)evt)) {
            this._nextAction.doAction();
        }
    }

    protected abstract void onIntentionIdle();

    protected abstract void onIntentionActive();

    protected abstract void onIntentionRest();

    protected abstract void onIntentionAttack(L2Character var1);

    protected abstract void onIntentionCast(Skill var1, L2Object var2);

    protected abstract void onIntentionMoveTo(Location var1);

    protected abstract void onIntentionFollow(L2Character var1);

    protected abstract void onIntentionPickUp(L2Object var1);

    protected abstract void onIntentionInteract(L2Object var1);

    protected abstract void onEvtThink();

    protected abstract void onEvtAttacked(L2Character var1);

    protected abstract void onEvtAggression(L2Character var1, long var2);

    protected abstract void onEvtStunned(L2Character var1);

    protected abstract void onEvtSleeping(L2Character var1);

    protected abstract void onEvtRooted(L2Character var1);

    protected abstract void onEvtConfused(L2Character var1);

    protected abstract void onEvtMuted(L2Character var1);

    protected abstract void onEvtEvaded(L2Character var1);

    protected abstract void onEvtReadyToAct();

    protected abstract void onEvtUserCmd(Object var1, Object var2);

    protected abstract void onEvtArrived();

    protected abstract void onEvtArrivedRevalidate();

    protected abstract void onEvtArrivedBlocked(Location var1);

    protected abstract void onEvtForgetObject(L2Object var1);

    protected abstract void onEvtCancel();

    protected abstract void onEvtDead();

    protected abstract void onEvtFakeDeath();

    protected abstract void onEvtFinishCasting();

    protected abstract void onEvtAfraid(L2Character var1, boolean var2);

    protected void clientActionFailed() {
        if (this._actor instanceof L2PcInstance) {
            this._actor.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    protected void moveToPawn(L2Object pawn, int offset) {
        if (!this._actor.isMovementDisabled()) {
            if (offset < 10) {
                offset = 10;
            }
            boolean sendPacket = true;
            if (this._clientMoving && this._target == pawn) {
                if (this._clientMovingToPawnOffset == offset) {
                    if (GameTimeController.getInstance().getGameTicks() < this._moveToPawnTimeout) {
                        return;
                    }
                    sendPacket = false;
                } else if (this._actor.isOnGeodataPath() && GameTimeController.getInstance().getGameTicks() < this._moveToPawnTimeout + 10) {
                    return;
                }
            }
            this._clientMoving = true;
            this._clientMovingToPawnOffset = offset;
            this._target = pawn;
            this._moveToPawnTimeout = GameTimeController.getInstance().getGameTicks();
            this._moveToPawnTimeout += 10;
            if (pawn == null) {
                return;
            }
            this._actor.moveToLocation(pawn.getX(), pawn.getY(), pawn.getZ(), offset);
            if (!this._actor.isMoving()) {
                this.clientActionFailed();
                return;
            }
            if (pawn instanceof L2Character) {
                if (this._actor.isOnGeodataPath()) {
                    this._actor.broadcastPacket(new MoveToLocation(this._actor));
                    this._clientMovingToPawnOffset = 0;
                } else if (sendPacket) {
                    this._actor.broadcastPacket(new MoveToPawn(this._actor, (L2Character)pawn, offset));
                }
            } else {
                this._actor.broadcastPacket(new MoveToLocation(this._actor));
            }
        } else {
            this.clientActionFailed();
        }
    }

    protected void moveTo(int x, int y, int z) {
        if (!this._actor.isMovementDisabled()) {
            this._clientMoving = true;
            this._clientMovingToPawnOffset = 0;
            this._actor.moveToLocation(x, y, z, 0);
            this._actor.broadcastPacket(new MoveToLocation(this._actor));
        } else {
            this.clientActionFailed();
        }
    }

    protected void clientStopMoving(Location loc) {
        if (this._actor.isMoving()) {
            this._actor.stopMove(loc);
        }
        this._clientMovingToPawnOffset = 0;
        if (this._clientMoving || loc != null) {
            this._clientMoving = false;
            this._actor.broadcastPacket(new StopMove(this._actor));
            if (loc != null) {
                this._actor.broadcastPacket(new StopRotation(this._actor.getObjectId(), loc.getHeading(), 0));
            }
        }
    }

    protected void clientStoppedMoving() {
        if (this._clientMovingToPawnOffset > 0) {
            this._clientMovingToPawnOffset = 0;
            this._actor.broadcastPacket(new StopMove(this._actor));
        }
        this._clientMoving = false;
    }

    public boolean isAutoAttacking() {
        return this._clientAutoAttacking;
    }

    public void setAutoAttacking(boolean isAutoAttacking) {
        L2Character l2Character = this._actor;
        if (l2Character instanceof L2Summon) {
            L2Summon summon = (L2Summon)l2Character;
            if (summon.getOwner() != null) {
                summon.getOwner().getAI().setAutoAttacking(isAutoAttacking);
            }
            return;
        }
        this._clientAutoAttacking = isAutoAttacking;
    }

    public void clientStartAutoAttack() {
        L2Character l2Character = this._actor;
        if (l2Character instanceof L2Summon) {
            L2Summon summon = (L2Summon)l2Character;
            if (summon.getOwner() != null) {
                summon.getOwner().getAI().clientStartAutoAttack();
            }
            return;
        }
        if (!this.isAutoAttacking()) {
            if (this._actor.isPlayer() && this._actor.hasSummon()) {
                this._actor.getSummon().broadcastPacket(new AutoAttackStart(this._actor.getSummon().getObjectId()));
            }
            this._actor.broadcastPacket(new AutoAttackStart(this._actor.getObjectId()));
            this.setAutoAttacking(true);
        }
        AttackStanceTaskManager.getInstance().addAttackStanceTask(this._actor);
    }

    public void clientStopAutoAttack() {
        L2Character l2Character = this._actor;
        if (l2Character instanceof L2Summon) {
            L2Summon summon = (L2Summon)l2Character;
            if (summon.getOwner() != null) {
                summon.getOwner().getAI().clientStopAutoAttack();
            }
            return;
        }
        if (this._actor instanceof L2PcInstance) {
            if (!AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._actor) && this.isAutoAttacking()) {
                AttackStanceTaskManager.getInstance().addAttackStanceTask(this._actor);
            }
        } else if (this.isAutoAttacking()) {
            this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
            this.setAutoAttacking(false);
        }
    }

    protected void clientNotifyDead() {
        Die msg = new Die(this._actor);
        this._actor.broadcastPacket(msg);
        this._intention = CtrlIntention.AI_INTENTION_IDLE;
        this._target = null;
        this._castTarget = null;
        this._attackTarget = null;
        this.stopFollow();
    }

    public void describeStateToPlayer(L2PcInstance player) {
        if (this.getActor().isVisibleFor(player) && this._clientMoving) {
            if (this._clientMovingToPawnOffset != 0 && this._followTarget != null) {
                player.sendPacket(new MoveToPawn(this._actor, this._followTarget, this._clientMovingToPawnOffset));
            } else {
                player.sendPacket(new MoveToLocation(this._actor));
            }
        }
    }

    public synchronized void startFollow(L2Character target) {
        if (this._followTask != null) {
            this._followTask.cancel(false);
            this._followTask = null;
        }
        this._followTarget = target;
        this._followTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new FollowTask(), 5L, 1000L);
    }

    public synchronized void startFollow(L2Character target, int range) {
        if (this._followTask != null) {
            this._followTask.cancel(false);
            this._followTask = null;
        }
        this._followTarget = target;
        this._followTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new FollowTask(range), 5L, 500L);
    }

    public synchronized void stopFollow() {
        if (this._followTask != null) {
            this._followTask.cancel(false);
            this._followTask = null;
        }
        this._followTarget = null;
    }

    protected L2Character getFollowTarget() {
        return this._followTarget;
    }

    protected L2Object getTarget() {
        return this._target;
    }

    protected void setTarget(L2Object target) {
        this._target = target;
    }

    public void stopAITask() {
        this.stopFollow();
    }

    public String toString() {
        return "Actor: " + String.valueOf(this._actor);
    }

    private class FollowTask
    implements Runnable {
        protected int _range = 70;

        public FollowTask() {
        }

        public FollowTask(int range) {
            this._range = range;
        }

        @Override
        public void run() {
            try {
                if (AbstractAI.this._followTask == null) {
                    return;
                }
                L2Character followTarget = AbstractAI.this._followTarget;
                if (followTarget == null) {
                    if (AbstractAI.this._actor instanceof L2Summon) {
                        ((L2Summon)AbstractAI.this._actor).setFollowStatus(false);
                    }
                    AbstractAI.this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    return;
                }
                if (!AbstractAI.this._actor.isInsideRadius(followTarget, this._range, true, false)) {
                    if (!AbstractAI.this._actor.isInsideRadius(followTarget, 3000, true, false)) {
                        if (AbstractAI.this._actor instanceof L2Summon) {
                            ((L2Summon)AbstractAI.this._actor).setFollowStatus(false);
                        }
                        AbstractAI.this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
                        return;
                    }
                    AbstractAI.this.moveToPawn(followTarget, this._range);
                }
            }
            catch (Exception e) {
                LOG.warn("{}: There has been a problem running the follow task!", (Object)this.getClass().getSimpleName(), (Object)e);
            }
        }
    }
}

