/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.MobGroup;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2ControllableMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.Util;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class L2ControllableMobAI
extends L2AttackableAI {
    public static final int AI_IDLE = 1;
    public static final int AI_NORMAL = 2;
    public static final int AI_FORCE_ATTACK = 3;
    public static final int AI_FOLLOW = 4;
    public static final int AI_CAST = 5;
    public static final int AI_ATTACK_GROUP = 6;
    private int _alternateAI;
    private boolean _isThinking;
    private boolean _isNotMoving;
    private L2Character _forcedTarget;
    private MobGroup _targetGroup;

    public L2ControllableMobAI(L2ControllableMobInstance creature) {
        super(creature);
        this.setAlternateAI(1);
    }

    protected void thinkFollow() {
        L2Attackable me = (L2Attackable)this._actor;
        if (!Util.checkIfInRange(300, me, this.getForcedTarget(), true)) {
            int signX = Rnd.nextInt((int)2) == 0 ? -1 : 1;
            int signY = Rnd.nextInt((int)2) == 0 ? -1 : 1;
            int randX = Rnd.nextInt((int)300);
            int randY = Rnd.nextInt((int)300);
            this.moveTo(this.getForcedTarget().getX() + signX * randX, this.getForcedTarget().getY() + signY * randY, this.getForcedTarget().getZ());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onEvtThink() {
        if (this._isThinking) {
            return;
        }
        this._isThinking = true;
        try {
            switch (this.getAlternateAI()) {
                case 1: {
                    if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) return;
                    this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                    return;
                }
                case 4: {
                    this.thinkFollow();
                    return;
                }
                case 5: {
                    this.thinkCast();
                    return;
                }
                case 3: {
                    this.thinkForceAttack();
                    return;
                }
                case 6: {
                    this.thinkAttackGroup();
                    return;
                }
                default: {
                    if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) {
                        this.thinkActive();
                        return;
                    } else {
                        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) return;
                        this.thinkAttack();
                    }
                    return;
                }
            }
        }
        finally {
            this._isThinking = false;
        }
    }

    @Override
    protected void thinkCast() {
        L2Character attackTarget = this.getAttackTarget();
        if (attackTarget == null || attackTarget.isAlikeDead()) {
            this.setAttackTarget(this.findNextRndTarget());
            this.clientStopMoving(null);
            if (attackTarget == null) {
                return;
            }
        }
        L2Attackable actor = this.getActor();
        actor.setTarget(attackTarget);
        if (!this._actor.isMuted()) {
            int max_range = 0;
            for (Skill sk : this._actor.getAllSkills()) {
                if (Util.checkIfInRange(sk.getCastRange(), this._actor, attackTarget, true) && !this._actor.isSkillDisabled(sk) && this._actor.getCurrentMp() > (double)this._actor.getStat().getMpConsume2(sk)) {
                    this._actor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, sk.getCastRange());
            }
            if (!this.isNotMoving()) {
                this.moveToPawn(attackTarget, max_range);
            }
        }
    }

    protected void thinkAttackGroup() {
        int range;
        L2Character target = this.getForcedTarget();
        if (target == null || target.isAlikeDead()) {
            this.setForcedTarget(this.findNextGroupTarget());
            this.clientStopMoving(null);
        }
        if (target == null) {
            return;
        }
        this._actor.setTarget(target);
        L2ControllableMobInstance theTarget = (L2ControllableMobInstance)target;
        L2ControllableMobAI ctrlAi = (L2ControllableMobAI)theTarget.getAI();
        ctrlAi.forceAttack(this._actor);
        double dist2 = this._actor.calculateDistance(target, false, true);
        int max_range = range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().getCollisionRadius() + target.getTemplate().getCollisionRadius();
        if (!this._actor.isMuted() && dist2 > (double)((range + 20) * (range + 20))) {
            for (Skill sk : this._actor.getAllSkills()) {
                int castRange = sk.getCastRange();
                if ((double)(castRange * castRange) >= dist2 && !this._actor.isSkillDisabled(sk) && this._actor.getCurrentMp() > (double)this._actor.getStat().getMpConsume2(sk)) {
                    this._actor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, castRange);
            }
            if (!this.isNotMoving()) {
                this.moveToPawn(target, range);
            }
            return;
        }
        this._actor.doAttack(target);
    }

    protected void thinkForceAttack() {
        int range;
        if (this.getForcedTarget() == null || this.getForcedTarget().isAlikeDead()) {
            this.clientStopMoving(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.setAlternateAI(1);
        }
        this._actor.setTarget(this.getForcedTarget());
        double dist2 = this._actor.calculateDistance(this.getForcedTarget(), false, true);
        int max_range = range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().getCollisionRadius() + this.getForcedTarget().getTemplate().getCollisionRadius();
        if (!this._actor.isMuted() && dist2 > (double)((range + 20) * (range + 20))) {
            for (Skill sk : this._actor.getAllSkills()) {
                int castRange = sk.getCastRange();
                if ((double)(castRange * castRange) >= dist2 && !this._actor.isSkillDisabled(sk) && this._actor.getCurrentMp() > (double)this._actor.getStat().getMpConsume2(sk)) {
                    this._actor.doCast(sk);
                    return;
                }
                max_range = Math.max(max_range, castRange);
            }
            if (!this.isNotMoving()) {
                this.moveToPawn(this.getForcedTarget(), this._actor.getPhysicalAttackRange());
            }
            return;
        }
        this._actor.doAttack(this.getForcedTarget());
    }

    @Override
    protected void thinkAttack() {
        if (this.getAttackTarget() == null || this.getAttackTarget().isAlikeDead()) {
            if (this.getAttackTarget() != null) {
                L2Attackable npc = (L2Attackable)this._actor;
                npc.stopHating(this.getAttackTarget());
            }
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        } else {
            int range;
            if (((L2Npc)this._actor).getTemplate().getClans() != null) {
                Collection<L2Object> objs = this._actor.getKnownList().getKnownObjects().values();
                for (L2Object obj : objs) {
                    L2Npc npc;
                    if (!(obj instanceof L2Npc) || !(npc = (L2Npc)obj).isInMyClan((L2Npc)this._actor) || !this._actor.isInsideRadius(npc, npc.getTemplate().getClanHelpRange(), false, true) || Math.abs(this.getAttackTarget().getZ() - npc.getZ()) >= 200) continue;
                    npc.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, this.getAttackTarget(), 1);
                }
            }
            this._actor.setTarget(this.getAttackTarget());
            double dist2 = this._actor.calculateDistance(this.getAttackTarget(), false, true);
            int max_range = range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius();
            if (!this._actor.isMuted() && dist2 > (double)((range + 20) * (range + 20))) {
                for (Skill sk : this._actor.getAllSkills()) {
                    int castRange = sk.getCastRange();
                    if ((double)(castRange * castRange) >= dist2 && !this._actor.isSkillDisabled(sk) && this._actor.getCurrentMp() > (double)this._actor.getStat().getMpConsume2(sk)) {
                        this._actor.doCast(sk);
                        return;
                    }
                    max_range = Math.max(max_range, castRange);
                }
                this.moveToPawn(this.getAttackTarget(), range);
                return;
            }
            L2Character hated = this._actor.isConfused() ? this.findNextRndTarget() : this.getAttackTarget();
            if (hated == null) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                return;
            }
            if (hated != this.getAttackTarget()) {
                this.setAttackTarget(hated);
            }
            if (!this._actor.isMuted() && Rnd.nextInt((int)5) == 3) {
                for (Skill sk : this._actor.getAllSkills()) {
                    int castRange = sk.getCastRange();
                    if (!((double)(castRange * castRange) >= dist2) || this._actor.isSkillDisabled(sk) || !(this._actor.getCurrentMp() < (double)this._actor.getStat().getMpConsume2(sk))) continue;
                    this._actor.doCast(sk);
                    return;
                }
            }
            this._actor.doAttack(this.getAttackTarget());
        }
    }

    @Override
    protected void thinkActive() {
        this.setAttackTarget(this.findNextRndTarget());
        L2Character hated = this._actor.isConfused() ? this.findNextRndTarget() : this.getAttackTarget();
        if (hated != null) {
            this._actor.setRunning();
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated);
        }
    }

    private boolean checkAutoAttackCondition(L2Character target) {
        if (target == null || target instanceof L2NpcInstance || target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isNpc()) {
            return false;
        }
        if (target.isInvul() || target.isAlikeDead()) {
            return false;
        }
        if (target.isPlayer() && ((L2PcInstance)target).isSpawnProtected()) {
            return false;
        }
        L2Attackable actor = this.getActor();
        if (!this._actor.isInsideRadius(target, actor.getAggroRange(), false, false) || Math.abs(this._actor.getZ() - target.getZ()) > 100) {
            return false;
        }
        if (target.isPlayable() && ((L2Playable)target).isSilentMovingAffected()) {
            return false;
        }
        return actor.isAggressive();
    }

    private L2Character findNextRndTarget() {
        List potentialTarget = this._actor.getKnownList().getKnownCharactersInRadius(this.getActor().getAggroRange()).stream().filter(this::checkAutoAttackCondition).collect(Collectors.toList());
        if (potentialTarget.isEmpty()) {
            return null;
        }
        return (L2Character)potentialTarget.get(Rnd.nextInt((int)potentialTarget.size()));
    }

    private L2ControllableMobInstance findNextGroupTarget() {
        return this.getGroupTarget().getRandomMob();
    }

    public int getAlternateAI() {
        return this._alternateAI;
    }

    public void setAlternateAI(int alternateAI) {
        this._alternateAI = alternateAI;
    }

    public void forceAttack(L2Character target) {
        this.setAlternateAI(3);
        this.setForcedTarget(target);
    }

    public void forceAttackGroup(MobGroup group) {
        this.setForcedTarget(null);
        this.setGroupTarget(group);
        this.setAlternateAI(6);
    }

    public void stop() {
        this.setAlternateAI(1);
        this.clientStopMoving(null);
    }

    public void move(int x, int y, int z) {
        this.moveTo(x, y, z);
    }

    public void follow(L2Character target) {
        this.setAlternateAI(4);
        this.setForcedTarget(target);
    }

    public boolean isNotMoving() {
        return this._isNotMoving;
    }

    public void setNotMoving(boolean isNotMoving) {
        this._isNotMoving = isNotMoving;
    }

    private L2Character getForcedTarget() {
        return this._forcedTarget;
    }

    private MobGroup getGroupTarget() {
        return this._targetGroup;
    }

    private void setForcedTarget(L2Character forcedTarget) {
        this._forcedTarget = forcedTarget;
    }

    private void setGroupTarget(MobGroup targetGroup) {
        this._targetGroup = targetGroup;
    }
}

