/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.commons.util.Rnd;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.Util;
import java.util.Collection;
import java.util.concurrent.Future;

public class L2FortSiegeGuardAI
extends L2CharacterAI
implements Runnable {
    private static final int MAX_ATTACK_TIMEOUT = 300;
    private Future<?> _aiTask;
    private final L2CharacterAI.SelfAnalysis _selfAnalysis = new L2CharacterAI.SelfAnalysis();
    private int _attackTimeout;
    private int _globalAggro;
    private boolean _thinking;
    private final int _attackRange;

    public L2FortSiegeGuardAI(L2DefenderInstance creature) {
        super(creature);
        this._selfAnalysis.init();
        this._attackTimeout = Integer.MAX_VALUE;
        this._globalAggro = -10;
        this._attackRange = this._actor.getPhysicalAttackRange();
    }

    @Override
    public void run() {
        this.onEvtThink();
    }

    private boolean autoAttackCondition(L2Character target) {
        L2Playable playable;
        L2PcInstance owner;
        if (target == null || target instanceof L2DefenderInstance || target instanceof L2NpcInstance || target instanceof L2DoorInstance || target.isAlikeDead() || target instanceof L2FortCommanderInstance || target instanceof L2Playable) {
            L2PcInstance player = null;
            if (target instanceof L2PcInstance) {
                player = (L2PcInstance)target;
            } else if (target instanceof L2Summon) {
                player = ((L2Summon)target).getOwner();
            }
            if (player == null || player.getClan() != null && player.getClan().getFortId() == ((L2Npc)this._actor).getFort().getResidenceId()) {
                return false;
            }
        }
        if (target.isInvul()) {
            if (target.isPlayer() && target.isGM()) {
                return false;
            }
            if (target.isSummon() && ((L2Summon)target).getOwner().isGM()) {
                return false;
            }
        }
        if (target instanceof L2Summon && this._actor.isInsideRadius(owner = ((L2Summon)target).getOwner(), 1000, true, false)) {
            target = owner;
        }
        if (target instanceof L2Playable && (playable = (L2Playable)target).isSilentMovingAffected() && !this._actor.isInsideRadius(target, 250, false, false)) {
            return false;
        }
        return this._actor.isAutoAttackable(target) && GeoData.getInstance().canSeeTarget((L2Object)this._actor, target);
    }

    @Override
    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        LOG.debug("{}: changeIntention({}, {}, {})", new Object[]{this.getClass().getSimpleName(), intention, arg0, arg1});
        if (intention == CtrlIntention.AI_INTENTION_IDLE) {
            if (!this._actor.isAlikeDead()) {
                L2Attackable npc = (L2Attackable)this._actor;
                intention = !npc.getKnownList().getKnownPlayers().isEmpty() ? CtrlIntention.AI_INTENTION_ACTIVE : CtrlIntention.AI_INTENTION_IDLE;
            }
            if (intention == CtrlIntention.AI_INTENTION_IDLE) {
                super.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                if (this._aiTask != null) {
                    this._aiTask.cancel(true);
                    this._aiTask = null;
                }
                this._actor.detachAI();
                return;
            }
        }
        super.changeIntention(intention, arg0, arg1);
        if (this._aiTask == null && this._actor.isInActiveRegion()) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(this, 1000L, 1000L);
        }
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        this._attackTimeout = 300 + GameTimeController.getInstance().getGameTicks();
        super.onIntentionAttack(target);
    }

    private void thinkActive() {
        L2Attackable npc = (L2Attackable)this._actor;
        if (this._globalAggro != 0) {
            this._globalAggro = this._globalAggro < 0 ? ++this._globalAggro : --this._globalAggro;
        }
        if (this._globalAggro >= 0) {
            for (L2Character target : npc.getKnownList().getKnownCharactersInRadius(this._attackRange)) {
                long hating;
                if (target == null || !this.autoAttackCondition(target) || (hating = npc.getHating(target)) != 0L) continue;
                npc.addDamageHate(target, 0, 1L);
            }
            L2Character hated = this._actor.isConfused() ? this.getAttackTarget() : npc.getMostHated();
            if (hated != null) {
                long aggro = npc.getHating(hated);
                if (aggro + (long)this._globalAggro > 0L) {
                    if (!this._actor.isRunning()) {
                        this._actor.setRunning();
                    }
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated, null);
                }
                return;
            }
        }
        if (this._actor.getWalkSpeed() >= 0.0) {
            L2Character l2Character = this._actor;
            if (l2Character instanceof L2DefenderInstance) {
                L2DefenderInstance defender = (L2DefenderInstance)l2Character;
                defender.returnHome();
            } else {
                ((L2FortCommanderInstance)this._actor).returnHome();
            }
        }
    }

    private void thinkAttack() {
        L2Character attackTarget;
        LOG.debug("{}: thinkAttack(); timeout={}", (Object)this.getClass().getSimpleName(), (Object)(this._attackTimeout - GameTimeController.getInstance().getGameTicks()));
        if (this._attackTimeout < GameTimeController.getInstance().getGameTicks() && this._actor.isRunning()) {
            this._actor.setWalking();
            this._attackTimeout = 300 + GameTimeController.getInstance().getGameTicks();
        }
        if ((attackTarget = this.getAttackTarget()) == null || attackTarget.isAlikeDead() || this._attackTimeout < GameTimeController.getInstance().getGameTicks()) {
            if (attackTarget != null) {
                L2Attackable npc = (L2Attackable)this._actor;
                npc.stopHating(attackTarget);
            }
            this._attackTimeout = Integer.MAX_VALUE;
            this.setAttackTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null, null);
            this._actor.setWalking();
            return;
        }
        this.factionNotifyAndSupport();
        this.attackPrepare();
    }

    private void factionNotifyAndSupport() {
        L2Character target = this.getAttackTarget();
        if (((L2Npc)this._actor).getTemplate().getClans() == null || target == null) {
            return;
        }
        if (target.isInvul()) {
            return;
        }
        block0: for (L2Character cha : this._actor.getKnownList().getKnownCharactersInRadius(1000L)) {
            int chance;
            L2Npc npc;
            if (cha == null) continue;
            if (cha instanceof L2Npc) {
                npc = (L2Npc)cha;
            } else {
                if (!this._selfAnalysis.hasHealOrResurrect || !(cha instanceof L2PcInstance) || !((L2Npc)this._actor).getFort().getSiege().checkIsDefender(cha.getClan()) || this._actor.isAttackingDisabled() || !(cha.getCurrentHp() < (double)cha.getMaxHp() * 0.6) || !(this._actor.getCurrentHp() > (double)this._actor.getMaxHp() / 2.0) || !(this._actor.getCurrentMp() > (double)this._actor.getMaxMp() / 2.0) || !cha.isInCombat()) continue;
                for (Skill sk : this._selfAnalysis.healSkills) {
                    if (this._actor.getCurrentMp() < (double)sk.getMpConsume2() || this._actor.isSkillDisabled(sk) || !Util.checkIfInRange(sk.getCastRange(), this._actor, cha, true) || (chance = 5) >= Rnd.get((int)100)) continue;
                    if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, cha)) continue block0;
                    L2Object oldTarget = this._actor.getTarget();
                    this._actor.setTarget(cha);
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    this._actor.setTarget(oldTarget);
                    return;
                }
                continue;
            }
            if (!npc.isInMyClan((L2Npc)this._actor) || npc.getAI() == null) continue;
            if (!npc.isDead() && Math.abs(target.getZ() - npc.getZ()) < 600 && (npc.getAI()._intention == CtrlIntention.AI_INTENTION_IDLE || npc.getAI()._intention == CtrlIntention.AI_INTENTION_ACTIVE) && target.isInsideRadius(npc, 1500, true, false) && GeoData.getInstance().canSeeTarget((L2Object)npc, target)) {
                npc.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, this.getAttackTarget(), 1);
                return;
            }
            if (!this._selfAnalysis.hasHealOrResurrect || this._actor.isAttackingDisabled() || !(npc.getCurrentHp() < (double)npc.getMaxHp() * 0.6) || !(this._actor.getCurrentHp() > (double)this._actor.getMaxHp() / 2.0) || !(this._actor.getCurrentMp() > (double)this._actor.getMaxMp() / 2.0) || !npc.isInCombat()) continue;
            for (Skill sk : this._selfAnalysis.healSkills) {
                if (this._actor.getCurrentMp() < (double)sk.getMpConsume2() || this._actor.isSkillDisabled(sk) || !Util.checkIfInRange(sk.getCastRange(), this._actor, npc, true) || (chance = 4) >= Rnd.get((int)100)) continue;
                if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, npc)) continue block0;
                L2Object OldTarget = this._actor.getTarget();
                this._actor.setTarget(npc);
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                this._actor.setTarget(OldTarget);
                return;
            }
        }
    }

    private void attackPrepare() {
        int range;
        double dist_2;
        Collection<Skill> skills;
        L2DefenderInstance sGuard = this._actor instanceof L2FortCommanderInstance ? (L2FortCommanderInstance)this._actor : (L2DefenderInstance)this._actor;
        L2Character attackTarget = this.getAttackTarget();
        try {
            this._actor.setTarget(attackTarget);
            skills = this._actor.getAllSkills();
            dist_2 = this._actor.calculateDistance(attackTarget, false, true);
            range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().getCollisionRadius() + attackTarget.getTemplate().getCollisionRadius();
            if (attackTarget.isMoving()) {
                range += 50;
            }
        }
        catch (NullPointerException e) {
            LOG.warn("{}: Attack target is NULL.", (Object)this.getClass().getSimpleName());
            this._actor.setTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            return;
        }
        if (attackTarget instanceof L2PcInstance && sGuard.getFort().getSiege().checkIsDefender(attackTarget.getClan())) {
            sGuard.stopHating(attackTarget);
            this._actor.setTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            return;
        }
        if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget)) {
            sGuard.stopHating(attackTarget);
            this._actor.setTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            return;
        }
        if (!this._actor.isMuted() && dist_2 > (double)(range * range)) {
            for (Skill sk : skills) {
                int castRange = sk.getCastRange();
                if (!(dist_2 <= (double)(castRange * castRange)) || castRange <= 70 || this._actor.isSkillDisabled(sk) || !(this._actor.getCurrentMp() >= (double)this._actor.getStat().getMpConsume2(sk)) || sk.isPassive()) continue;
                L2Object OldTarget = this._actor.getTarget();
                if (sk.isContinuous() && !sk.isDebuff() || sk.hasEffectType(L2EffectType.HP, new L2EffectType[0])) {
                    boolean useSkillSelf = true;
                    if (sk.hasEffectType(L2EffectType.HP, new L2EffectType[0]) && this._actor.getCurrentHp() > (double)((int)((double)this._actor.getMaxHp() / 1.5))) {
                        useSkillSelf = false;
                        break;
                    }
                    if (sk.isContinuous() && !sk.isDebuff() && this._actor.isAffectedBySkill(sk.getId())) {
                        useSkillSelf = false;
                    }
                    if (useSkillSelf) {
                        this._actor.setTarget(this._actor);
                    }
                }
                this.clientStopMoving(null);
                this._actor.doCast(sk);
                this._actor.setTarget(OldTarget);
                return;
            }
            if (!this._actor.isAttackingNow() && this._actor.getRunSpeed() == 0.0 && this._actor.getKnownList().knowsObject(attackTarget)) {
                this._actor.getKnownList().removeKnownObject(attackTarget);
                this._actor.setTarget(null);
                this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            } else {
                double dx = this._actor.getX() - attackTarget.getX();
                double dy = this._actor.getY() - attackTarget.getY();
                double dz = this._actor.getZ() - attackTarget.getZ();
                double homeX = attackTarget.getX() - sGuard.getSpawn().getX();
                double homeY = attackTarget.getY() - sGuard.getSpawn().getY();
                if (dx * dx + dy * dy > 10000.0 && homeX * homeX + homeY * homeY > 3240000.0 && this._actor.getKnownList().knowsObject(attackTarget)) {
                    this._actor.getKnownList().removeKnownObject(attackTarget);
                    this._actor.setTarget(null);
                    this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                } else if (dz * dz < 28900.0) {
                    if (this._selfAnalysis.isMage) {
                        range = this._selfAnalysis.maxCastRange - 50;
                    }
                    if (this._actor.getWalkSpeed() <= 0.0) {
                        return;
                    }
                    if (attackTarget.isMoving()) {
                        this.moveToPawn(attackTarget, range - 70);
                    } else {
                        this.moveToPawn(attackTarget, range);
                    }
                }
            }
        } else if (this._actor.isMuted() && dist_2 > (double)(range * range)) {
            double dz = this._actor.getZ() - attackTarget.getZ();
            if (dz * dz < 28900.0) {
                if (this._selfAnalysis.isMage) {
                    range = this._selfAnalysis.maxCastRange - 50;
                }
                if (this._actor.getWalkSpeed() <= 0.0) {
                    return;
                }
                if (attackTarget.isMoving()) {
                    this.moveToPawn(attackTarget, range - 70);
                } else {
                    this.moveToPawn(attackTarget, range);
                }
            }
        } else if (dist_2 <= (double)(range * range)) {
            L2Character hated = this._actor.isConfused() ? attackTarget : ((L2Attackable)this._actor).getMostHated();
            if (hated == null) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null, null);
                return;
            }
            if (hated != attackTarget) {
                attackTarget = hated;
            }
            this._attackTimeout = 300 + GameTimeController.getInstance().getGameTicks();
            if (!this._actor.isMuted() && Rnd.nextInt((int)100) <= 5) {
                for (Skill sk : skills) {
                    int castRange = sk.getCastRange();
                    if (!((double)(castRange * castRange) >= dist_2) || sk.isPassive() || !(this._actor.getCurrentMp() >= (double)this._actor.getStat().getMpConsume2(sk)) || this._actor.isSkillDisabled(sk)) continue;
                    L2Object OldTarget = this._actor.getTarget();
                    if (sk.isContinuous() && !sk.isDebuff() || sk.hasEffectType(L2EffectType.HP, new L2EffectType[0])) {
                        boolean useSkillSelf = true;
                        if (sk.hasEffectType(L2EffectType.HP, new L2EffectType[0]) && this._actor.getCurrentHp() > (double)((int)((double)this._actor.getMaxHp() / 1.5))) {
                            useSkillSelf = false;
                            break;
                        }
                        if (sk.isContinuous() && !sk.isDebuff() && this._actor.isAffectedBySkill(sk.getId())) {
                            useSkillSelf = false;
                        }
                        if (useSkillSelf) {
                            this._actor.setTarget(this._actor);
                        }
                    }
                    this.clientStopMoving(null);
                    this._actor.doCast(sk);
                    this._actor.setTarget(OldTarget);
                    return;
                }
            }
            this._actor.doAttack(attackTarget);
        }
    }

    @Override
    protected void onEvtThink() {
        if (this._thinking || this._actor.isCastingNow() || this._actor.isAllSkillsDisabled()) {
            return;
        }
        this._thinking = true;
        try {
            if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) {
                this.thinkActive();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            }
        }
        finally {
            this._thinking = false;
        }
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        this._attackTimeout = 300 + GameTimeController.getInstance().getGameTicks();
        if (this._globalAggro < 0) {
            this._globalAggro = 0;
        }
        ((L2Attackable)this._actor).addDamageHate(attacker, 0, 1L);
        if (!this._actor.isRunning()) {
            this._actor.setRunning();
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker, null);
        }
        super.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtAggression(L2Character target, long aggro) {
        if (this._actor == null) {
            return;
        }
        L2Attackable me = (L2Attackable)this._actor;
        if (target != null) {
            me.addDamageHate(target, 0, aggro);
            aggro = me.getHating(target);
            if (aggro <= 0L) {
                if (me.getMostHated() == null) {
                    this._globalAggro = -25;
                    me.clearAggroList();
                    this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                }
                return;
            }
            if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
                double homeY;
                if (!this._actor.isRunning()) {
                    this._actor.setRunning();
                }
                L2DefenderInstance sGuard = this._actor instanceof L2FortCommanderInstance ? (L2FortCommanderInstance)this._actor : (L2DefenderInstance)this._actor;
                double homeX = target.getX() - sGuard.getSpawn().getX();
                if (homeX * homeX + (homeY = (double)(target.getY() - sGuard.getSpawn().getY())) * homeY < 3240000.0) {
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target, null);
                }
            }
        } else {
            if (aggro >= 0L) {
                return;
            }
            L2Character mostHated = me.getMostHated();
            if (mostHated == null) {
                this._globalAggro = -25;
                return;
            }
            for (L2Character attacker : me.getAggroList().keySet()) {
                me.addDamageHate(attacker, 0, aggro);
            }
            aggro = me.getHating(mostHated);
            if (aggro <= 0L) {
                this._globalAggro = -25;
                me.clearAggroList();
                this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            }
        }
    }

    @Override
    public void stopAITask() {
        if (this._aiTask != null) {
            this._aiTask.cancel(false);
            this._aiTask = null;
        }
        this._actor.detachAI();
        super.stopAITask();
    }
}

