/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.bbs.model;

import com.l2jserver.gameserver.bbs.model.ForumType;
import com.l2jserver.gameserver.bbs.model.ForumVisibility;
import com.l2jserver.gameserver.bbs.model.Topic;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Forum {
    private int id;
    private String name;
    private ForumType type;
    private int post;
    private ForumVisibility visibility;
    private final Forum parent;
    private int ownerId;
    private final Map<String, Forum> children = new ConcurrentHashMap<String, Forum>();
    private final Map<Integer, Topic> topics = new ConcurrentHashMap<Integer, Topic>();

    public Forum(int id, String name, Forum parent, ForumType type, ForumVisibility visibility, int ownerId) {
        this.name = name;
        this.id = id;
        this.type = type;
        this.post = 0;
        this.visibility = visibility;
        this.parent = parent;
        this.ownerId = ownerId;
    }

    public int getTopicSize() {
        return this.topics.size();
    }

    public Topic getTopic(int topicId) {
        return this.topics.get(topicId);
    }

    public void addTopic(Topic t) {
        this.topics.put(t.getId(), t);
    }

    public void removeTopic(int topicId) {
        this.topics.remove(topicId);
    }

    public Forum getChildByName(String name) {
        return this.children.get(name);
    }

    public void addChild(Forum child) {
        this.children.put(child.getName(), child);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ForumType getType() {
        return this.type;
    }

    public void setType(ForumType type) {
        this.type = type;
    }

    public int getPost() {
        return this.post;
    }

    public void setPost(int post) {
        this.post = post;
    }

    public ForumVisibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(ForumVisibility visibility) {
        this.visibility = visibility;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(int ownerId) {
        this.ownerId = ownerId;
    }

    public Forum getParent() {
        return this.parent;
    }

    public Map<String, Forum> getChildren() {
        return this.children;
    }

    public Map<Integer, Topic> getTopics() {
        return this.topics;
    }
}

