/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.config;

import com.l2jserver.gameserver.config.converter.ItemHolderConverter;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.aeonbits.owner.Config;
import org.aeonbits.owner.Reloadable;

@Config.Sources(value={"file:${L2J_HOME}/custom/game/config/olympiad.properties", "file:./config/olympiad.properties", "classpath:config/olympiad.properties"})
@Config.LoadPolicy(value=Config.LoadType.MERGE)
@Config.HotReload(value=20L, unit=TimeUnit.MINUTES, type=Config.HotReloadType.ASYNC)
public interface OlympiadConfiguration
extends Reloadable {
    @Config.Key(value="StartHour")
    public int getStartHour();

    @Config.Key(value="StartMinute")
    public int getStartMinute();

    @Config.Key(value="MaxBuffs")
    public int getMaxBuffs();

    @Config.Key(value="CompetitionPeriod")
    public int getCompetitionPeriod();

    @Config.Key(value="BattlePeriod")
    public int getBattlePeriod();

    @Config.Key(value="WeeklyPeriod")
    public int getWeeklyPeriod();

    @Config.Key(value="ValidationPeriod")
    public int getValidationPeriod();

    @Config.Key(value="StartPoints")
    public int getStartPoints();

    @Config.Key(value="WeeklyPoints")
    public int getWeeklyPoints();

    @Config.Key(value="ClassedParticipants")
    public int getClassedParticipants();

    @Config.Key(value="NonClassedParticipants")
    public int getNonClassedParticipants();

    @Config.Key(value="TeamsParticipants")
    public int getTeamsParticipants();

    @Config.Key(value="RegistrationDisplayNumber")
    public int getRegistrationDisplayNumber();

    @Config.Separator(value=";")
    @Config.Key(value="ClassedReward")
    @Config.ConverterClass(value=ItemHolderConverter.class)
    public List<ItemHolder> getClassedReward();

    @Config.Separator(value=";")
    @Config.Key(value="NonClassedReward")
    @Config.ConverterClass(value=ItemHolderConverter.class)
    public List<ItemHolder> getNonClassedReward();

    @Config.Separator(value=";")
    @Config.Key(value="TeamReward")
    @Config.ConverterClass(value=ItemHolderConverter.class)
    public List<ItemHolder> getTeamReward();

    @Config.Key(value="CompetitionRewardItem")
    public int getCompetitionRewardItem();

    @Config.Key(value="MinMatchesForPoints")
    public int getMinMatchesForPoints();

    @Config.Key(value="GPPerPoint")
    public int getGPPerPoint();

    @Config.Key(value="HeroPoints")
    public int getHeroPoints();

    @Config.Key(value="Rank1Points")
    public int getRank1Points();

    @Config.Key(value="Rank2Points")
    public int getRank2Points();

    @Config.Key(value="Rank3Points")
    public int getRank3Points();

    @Config.Key(value="Rank4Points")
    public int getRank4Points();

    @Config.Key(value="Rank5Points")
    public int getRank5Points();

    @Config.Key(value="MaxPoints")
    public int getMaxPoints();

    @Config.Key(value="ShowMonthlyWinners")
    public boolean showMonthlyWinners();

    @Config.Key(value="AnnounceGames")
    public boolean announceGames();

    @Config.Key(value="RestrictedItems")
    public Set<Integer> getRestrictedItems();

    @Config.Key(value="EnchantLimit")
    public int getEnchantLimit();

    @Config.Key(value="LogFights")
    public boolean logFights();

    @Config.Key(value="WaitTime")
    public int getWaitTime();

    @Config.Key(value="DividerClassed")
    public int getDividerClassed();

    @Config.Key(value="DividerNonClassed")
    public int getDividerNonClassed();

    @Config.Key(value="MaxWeeklyMatches")
    public int getMaxWeeklyMatches();

    @Config.Key(value="MaxWeeklyMatchesNonClassed")
    public int getMaxWeeklyMatchesNonClassed();

    @Config.Key(value="MaxWeeklyMatchesClassed")
    public int getMaxWeeklyMatchesClassed();

    @Config.Key(value="MaxWeeklyMatchesTeam")
    public int getMaxWeeklyMatchesTeam();

    @Config.Key(value="CurrentCycle")
    public Integer getCurrentCycle();

    @Config.Key(value="Period")
    public int getPeriod();

    @Config.Key(value="OlympiadEnd")
    public long getOlympiadEnd();

    @Config.Key(value="ValidationEnd")
    public long getValidationEnd();

    @Config.Key(value="NextWeeklyChange")
    public long getNextWeeklyChange();
}

