/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.ClanDAO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClanDAOMySQLImpl
implements ClanDAO {
    private static final Logger LOG = LoggerFactory.getLogger(ClanDAOMySQLImpl.class);
    private static final String SELECT_CLAN_PRIVILEGES = "SELECT `privs`, `rank`, `party` FROM `clan_privs` WHERE clan_id=?";
    private static final String INSERT_CLAN_PRIVILEGES = "INSERT INTO `clan_privs` (`clan_id`, `rank`, `party`, `privs`) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE `privs`=?";

    @Override
    public Map<Integer, Integer> getPrivileges(int clanId) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT_CLAN_PRIVILEGES);){
            ps.setInt(1, clanId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int rank = rs.getInt("rank");
                    if (rank == -1) continue;
                    result.put(rank, rs.getInt("privs"));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to restore clan privileges for clan Id {}!", (Object)clanId, (Object)ex);
        }
        return result;
    }

    @Override
    public void storePrivileges(int clanId, int rank, int privileges) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT_CLAN_PRIVILEGES);){
            ps.setInt(1, clanId);
            ps.setInt(2, rank);
            ps.setInt(3, 0);
            ps.setInt(4, privileges);
            ps.setInt(5, privileges);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("Unable to store clan privileges for clan Id {}!", (Object)clanId, (Object)ex);
        }
    }
}

