/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.ItemReuseDAO;
import com.l2jserver.gameserver.model.TimeStamp;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.ExUseSharedGroupItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemReuseDAOMySQLImpl
implements ItemReuseDAO {
    private static final Logger LOG = LoggerFactory.getLogger(ItemReuseDAOMySQLImpl.class);
    private static final String INSERT = "INSERT INTO character_item_reuse_save (charId,itemId,itemObjId,reuseDelay,systime) VALUES (?,?,?,?,?)";
    private static final String SELECT = "SELECT charId,itemId,itemObjId,reuseDelay,systime FROM character_item_reuse_save WHERE charId=?";
    private static final String DELETE = "DELETE FROM character_item_reuse_save WHERE charId=?";

    @Override
    public void delete(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE);){
            ps.setInt(1, player.getObjectId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.warn("Could not delete player's {} item reuse data!", (Object)player, (Object)e);
        }
    }

    @Override
    public void insert(L2PcInstance player) {
        this.delete(player);
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT);){
            Map<Integer, TimeStamp> itemReuseTimeStamps = player.getItemReuseTimeStamps();
            if (itemReuseTimeStamps != null) {
                for (TimeStamp ts : itemReuseTimeStamps.values()) {
                    if (ts == null || !ts.hasNotPassed()) continue;
                    ps.setInt(1, player.getObjectId());
                    ps.setInt(2, ts.getItemId());
                    ps.setInt(3, ts.getItemObjectId());
                    ps.setLong(4, ts.getReuse());
                    ps.setLong(5, ts.getStamp());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (Exception e) {
            LOG.warn("Could not store player's {} item reuse data!", (Object)player, (Object)e);
        }
    }

    @Override
    public void load(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT);){
            ps.setInt(1, player.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int group;
                    long remainingTime;
                    int itemId = rs.getInt("itemId");
                    long reuseDelay = rs.getLong("reuseDelay");
                    long systime = rs.getLong("systime");
                    boolean isInInventory = true;
                    L2ItemInstance item = player.getInventory().getItemByItemId(itemId);
                    if (item == null) {
                        item = player.getWarehouse().getItemByItemId(itemId);
                        isInInventory = false;
                    }
                    if (item == null || item.getId() != itemId || item.getReuseDelay() <= 0 || (remainingTime = systime - System.currentTimeMillis()) <= 10L) continue;
                    player.addTimeStampItem(item, reuseDelay, systime);
                    if (!isInInventory || !item.isEtcItem() || (group = item.getSharedReuseGroup()) <= 0) continue;
                    player.sendPacket(new ExUseSharedGroupItem(itemId, group, (int)remainingTime, (int)reuseDelay));
                }
            }
            this.delete(player);
        }
        catch (Exception e) {
            LOG.error("Could not restore {} Item Reuse data: {}", (Object)player, (Object)e);
        }
    }
}

