/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.dao.impl.mysql;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.dao.RecipeShopListDAO;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeShopListDAOMySQLImpl
implements RecipeShopListDAO {
    private static final Logger LOG = LoggerFactory.getLogger(RecipeShopListDAOMySQLImpl.class);
    private static final String DELETE = "DELETE FROM character_recipeshoplist WHERE charId=?";
    private static final String INSERT = "REPLACE INTO character_recipeshoplist (`charId`, `recipeId`, `price`, `index`) VALUES (?, ?, ?, ?)";
    private static final String SELECT = "SELECT * FROM character_recipeshoplist WHERE charId=? ORDER BY `index`";

    @Override
    public void load(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(SELECT);){
            player.getManufactureItems().clear();
            ps.setInt(1, player.getObjectId());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    player.getManufactureItems().put(rs.getInt("recipeId"), new L2ManufactureItem(rs.getInt("recipeId"), rs.getLong("price")));
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not restore recipe shop list data for {}, {}", (Object)player, (Object)e);
        }
    }

    @Override
    public void delete(L2PcInstance player) {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(DELETE);){
            ps.setInt(1, player.getObjectId());
            ps.execute();
        }
        catch (Exception e) {
            LOG.error("Could not store recipe shop for {}, {}", (Object)player, (Object)e);
        }
    }

    @Override
    public void insert(L2PcInstance player) {
        if (!player.hasManufactureShop()) {
            return;
        }
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement(INSERT);){
            int i = 1;
            for (L2ManufactureItem item : player.getManufactureItems().values()) {
                ps.setInt(1, player.getObjectId());
                ps.setInt(2, item.getRecipeId());
                ps.setLong(3, item.getCost());
                ps.setInt(4, i++);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            LOG.error("Could not store recipe shop for {}, {}", (Object)player, (Object)e);
        }
    }
}

