/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.announce.Announcement;
import com.l2jserver.gameserver.model.announce.AnnouncementType;
import com.l2jserver.gameserver.model.announce.AutoAnnouncement;
import com.l2jserver.gameserver.model.announce.IAnnouncement;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnouncementsTable {
    private static final Logger LOG = LoggerFactory.getLogger(AnnouncementsTable.class);
    private final Map<Integer, IAnnouncement> _announcements = new ConcurrentSkipListMap<Integer, IAnnouncement>();

    protected AnnouncementsTable() {
        this.load();
    }

    private void load() {
        this._announcements.clear();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT `id`, `type`, `initial`, `delay`, `repeat`, `author`, `content` FROM announcements");){
            block21: while (rs.next()) {
                Announcement announce;
                AnnouncementType type = AnnouncementType.findById(rs.getInt("type"));
                String author = rs.getString("author");
                String content = rs.getString("content");
                switch (type) {
                    case NORMAL: 
                    case CRITICAL: {
                        announce = new Announcement(rs.getInt("id"), type, content, author);
                        break;
                    }
                    case AUTO_NORMAL: 
                    case AUTO_CRITICAL: {
                        announce = new AutoAnnouncement(type, content, author, rs.getLong("initial"), rs.getLong("delay"), rs.getInt("repeat"));
                        break;
                    }
                    default: {
                        continue block21;
                    }
                }
                this._announcements.put(announce.getId(), announce);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed loading announcements:", e);
        }
    }

    public void showAnnouncements(L2PcInstance player) {
        this.sendAnnouncements(player, AnnouncementType.NORMAL);
        this.sendAnnouncements(player, AnnouncementType.CRITICAL);
        this.sendAnnouncements(player, AnnouncementType.EVENT);
    }

    public void sendAnnouncements(L2PcInstance player, AnnouncementType type) {
        for (IAnnouncement announce : this._announcements.values()) {
            if (!announce.isValid() || announce.getType() != type) continue;
            player.sendPacket(new CreatureSay(0, type == AnnouncementType.CRITICAL ? 18 : 10, player.getName(), announce.getContent()));
        }
    }

    public void addAnnouncement(IAnnouncement announce) {
        if (announce.storeMe()) {
            this._announcements.put(announce.getId(), announce);
        }
    }

    public boolean deleteAnnouncement(int id) {
        IAnnouncement announce = this._announcements.remove(id);
        return announce != null && announce.deleteMe();
    }

    public IAnnouncement getAnnounce(int id) {
        return this._announcements.get(id);
    }

    public Collection<IAnnouncement> getAllAnnouncements() {
        return this._announcements.values();
    }

    public static AnnouncementsTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final AnnouncementsTable _instance = new AnnouncementsTable();

        private SingletonHolder() {
        }
    }
}

