/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.data.sql.impl;

import com.l2jserver.commons.database.ConnectionFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.config.Configuration;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallSiegeManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Auction;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.FortSiege;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.ListenersContainer;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanCreate;
import com.l2jserver.gameserver.model.events.impl.character.player.clan.PlayerClanDestroy;
import com.l2jserver.gameserver.model.events.impl.clan.ClanWarFinish;
import com.l2jserver.gameserver.model.events.impl.clan.ClanWarStart;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAll;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.EnumIntBitmask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClanTable {
    private static final Logger LOG = LoggerFactory.getLogger(ClanTable.class);
    public static final int CLAN_NAME_MAX_LENGTH = 16;
    private final Map<Integer, L2Clan> _clans = new ConcurrentHashMap<Integer, L2Clan>();

    protected ClanTable() {
        int clanCount = 0;
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT clan_id FROM clan_data");){
            while (rs.next()) {
                int clanId = rs.getInt("clan_id");
                this._clans.put(clanId, new L2Clan(clanId));
                L2Clan clan = this.getClan(clanId);
                if (clan.getDissolvingExpiryTime() != 0L) {
                    this.scheduleRemoveClan(clan.getId());
                }
                ++clanCount;
            }
        }
        catch (Exception ex) {
            LOG.error("There has been an error restoring clans from database!", ex);
        }
        LOG.info("Restored {} clans from the database.", (Object)clanCount);
        this.allianceCheck();
        this.restorewars();
    }

    public Collection<L2Clan> getClans() {
        return this._clans.values();
    }

    public int getClanCount() {
        return this._clans.size();
    }

    public L2Clan getClan(int clanId) {
        return this._clans.get(clanId);
    }

    public L2Clan getClanByName(String clanName) {
        return this.getClans().stream().filter(c -> c.getName().equalsIgnoreCase(clanName)).findFirst().orElse(null);
    }

    public L2Clan createClan(L2PcInstance player, String clanName) {
        if (null == player) {
            return null;
        }
        if (Configuration.general().debug()) {
            LOG.info("{} requested a clan creation.", (Object)player);
        }
        if (10 > player.getLevel()) {
            player.sendPacket(SystemMessageId.YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_CLAN);
            return null;
        }
        if (0 != player.getClanId()) {
            player.sendPacket(SystemMessageId.FAILED_TO_CREATE_CLAN);
            return null;
        }
        if (System.currentTimeMillis() < player.getClanCreateExpiryTime()) {
            player.sendPacket(SystemMessageId.YOU_MUST_WAIT_XX_DAYS_BEFORE_CREATING_A_NEW_CLAN);
            return null;
        }
        if (clanName.length() < 2) {
            player.sendPacket(SystemMessageId.CLAN_NAME_INCORRECT);
            return null;
        }
        if (clanName.length() > 16) {
            player.sendPacket(SystemMessageId.CLAN_NAME_TOO_LONG);
            return null;
        }
        if (null != this.getClanByName(clanName)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ALREADY_EXISTS);
            sm.addString(clanName);
            player.sendPacket(sm);
            return null;
        }
        int objectId = IdFactory.getInstance().getNextId();
        L2Clan clan = new L2Clan(objectId, clanName);
        L2ClanMember leader = new L2ClanMember(clan, player);
        clan.setLeader(leader);
        leader.setPlayerInstance(player);
        clan.store();
        player.setClan(clan);
        player.setPledgeClass(L2ClanMember.calculatePledgeClass(player));
        player.setClanPrivileges(new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, true));
        this._clans.put(clan.getId(), clan);
        player.sendPacket(new PledgeShowInfoUpdate(clan));
        player.sendPacket(new PledgeShowMemberListAll(clan, player));
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        player.sendPacket(new PledgeShowMemberListUpdate(player));
        player.sendPacket(SystemMessageId.CLAN_CREATED);
        EventDispatcher.getInstance().notifyEventAsync(new PlayerClanCreate(player, clan), new ListenersContainer[0]);
        return clan;
    }

    public synchronized void destroyClan(int clanId) {
        L2ClanMember leaderMember;
        Auction auction;
        int n;
        int fortId;
        L2Clan clan = this.getClan(clanId);
        if (clan == null) {
            return;
        }
        clan.broadcastToOnlineMembers(SystemMessage.getSystemMessage(SystemMessageId.CLAN_HAS_DISPERSED));
        int castleId = clan.getCastleId();
        if (castleId == 0) {
            for (Siege siege : SiegeManager.getInstance().getSieges()) {
                siege.removeSiegeClan(clan);
            }
        }
        if ((fortId = clan.getFortId()) == 0) {
            for (FortSiege fortSiege : FortSiegeManager.getInstance().getSieges()) {
                fortSiege.removeAttacker(clan);
            }
        }
        if ((n = clan.getHideoutId()) == 0) {
            for (SiegableHall hall : ClanHallSiegeManager.getInstance().getConquerableHalls().values()) {
                hall.removeAttacker(clan);
            }
        }
        if ((auction = AuctionManager.getInstance().getAuction(clan.getAuctionBidAt())) != null) {
            auction.cancelBid(clan.getId());
        }
        if ((leaderMember = clan.getLeader()) == null) {
            clan.getWarehouse().destroyAllItems("ClanRemove", null, null);
        } else {
            clan.getWarehouse().destroyAllItems("ClanRemove", clan.getLeader().getPlayerInstance(), null);
        }
        for (L2ClanMember member : clan.getMembers()) {
            clan.removeClanMember(member.getObjectId(), 0L);
        }
        this._clans.remove(clanId);
        IdFactory.getInstance().releaseId(clanId);
        try (Connection con = ConnectionFactory.getInstance().getConnection();){
            SiegableHall hall;
            L2Clan owner;
            Fort fort;
            try (PreparedStatement ps = con.prepareStatement("DELETE FROM clan_data WHERE clan_id=?");){
                ps.setInt(1, clanId);
                ps.execute();
            }
            ps = con.prepareStatement("DELETE FROM clan_privs WHERE clan_id=?");
            try {
                ps.setInt(1, clanId);
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = con.prepareStatement("DELETE FROM clan_skills WHERE clan_id=?");
            try {
                ps.setInt(1, clanId);
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = con.prepareStatement("DELETE FROM clan_subpledges WHERE clan_id=?");
            try {
                ps.setInt(1, clanId);
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? OR clan2=?");
            try {
                ps.setInt(1, clanId);
                ps.setInt(2, clanId);
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = con.prepareStatement("DELETE FROM clan_notices WHERE clan_id=?");
            try {
                ps.setInt(1, clanId);
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            if (castleId != 0) {
                ps = con.prepareStatement("UPDATE castle SET taxPercent = 0 WHERE id = ?");
                try {
                    ps.setInt(1, castleId);
                    ps.execute();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            if (fortId != 0 && (fort = FortManager.getInstance().getFortById(fortId)) != null && clan == (owner = fort.getOwnerClan())) {
                fort.removeOwner(true);
            }
            if (n != 0 && (hall = ClanHallSiegeManager.getInstance().getSiegableHall(n)) != null && hall.getOwnerId() == clanId) {
                hall.free();
            }
        }
        catch (Exception ex) {
            LOG.error("There has been an error deleting a clan from database!", ex);
        }
        EventDispatcher.getInstance().notifyEventAsync(new PlayerClanDestroy(leaderMember, clan), new ListenersContainer[0]);
    }

    public void scheduleRemoveClan(int clanId) {
        ThreadPoolManager.getInstance().scheduleGeneral(() -> {
            if (this.getClan(clanId) == null) {
                return;
            }
            if (this.getClan(clanId).getDissolvingExpiryTime() != 0L) {
                this.destroyClan(clanId);
            }
        }, Math.max(this.getClan(clanId).getDissolvingExpiryTime() - System.currentTimeMillis(), 300000L));
    }

    public boolean isAllyExists(String allyName) {
        for (L2Clan clan : this.getClans()) {
            if (clan.getAllyName() == null || !clan.getAllyName().equalsIgnoreCase(allyName)) continue;
            return true;
        }
        return false;
    }

    public void storeclanswars(int clanId1, int clanId2) {
        L2Clan clan1 = this.getClan(clanId1);
        L2Clan clan2 = this.getClan(clanId2);
        EventDispatcher.getInstance().notifyEventAsync(new ClanWarStart(clan1, clan2), new ListenersContainer[0]);
        clan1.setEnemyClan(clan2);
        clan2.setAttackerClan(clan1);
        clan1.broadcastClanStatus();
        clan2.broadcastClanStatus();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("REPLACE INTO clan_wars (clan1, clan2, wantspeace1, wantspeace2) VALUES(?,?,?,?)");){
            ps.setInt(1, clanId1);
            ps.setInt(2, clanId2);
            ps.setInt(3, 0);
            ps.setInt(4, 0);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("There has been an error saving clan wars data!", ex);
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_WAR_DECLARED_AGAINST_S1_IF_KILLED_LOSE_LOW_EXP);
        msg.addString(clan2.getName());
        clan1.broadcastToOnlineMembers(msg);
        msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_DECLARED_WAR);
        msg.addString(clan1.getName());
        clan2.broadcastToOnlineMembers(msg);
    }

    public void deleteclanswars(int clanId1, int clanId2) {
        L2Clan clan1 = this.getClan(clanId1);
        L2Clan clan2 = this.getClan(clanId2);
        EventDispatcher.getInstance().notifyEventAsync(new ClanWarFinish(clan1, clan2), new ListenersContainer[0]);
        clan1.deleteEnemyClan(clan2);
        clan2.deleteAttackerClan(clan1);
        clan1.broadcastClanStatus();
        clan2.broadcastClanStatus();
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             PreparedStatement ps = con.prepareStatement("DELETE FROM clan_wars WHERE clan1=? AND clan2=?");){
            ps.setInt(1, clanId1);
            ps.setInt(2, clanId2);
            ps.execute();
        }
        catch (Exception ex) {
            LOG.error("There has been an error removing clan wars data!", ex);
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.WAR_AGAINST_S1_HAS_STOPPED);
        msg.addString(clan2.getName());
        clan1.broadcastToOnlineMembers(msg);
        msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_S1_HAS_DECIDED_TO_STOP);
        msg.addString(clan1.getName());
        clan2.broadcastToOnlineMembers(msg);
    }

    public void checkSurrender(L2Clan clan1, L2Clan clan2) {
        int count = 0;
        for (L2ClanMember player : clan1.getMembers()) {
            if (player == null || player.getPlayerInstance().getWantsPeace() != 1) continue;
            ++count;
        }
        if (count == clan1.getMembers().length - 1) {
            clan1.deleteEnemyClan(clan2);
            clan2.deleteEnemyClan(clan1);
            this.deleteclanswars(clan1.getId(), clan2.getId());
        }
    }

    private void restorewars() {
        try (Connection con = ConnectionFactory.getInstance().getConnection();
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT clan1, clan2 FROM clan_wars");){
            while (rs.next()) {
                L2Clan clan1 = this.getClan(rs.getInt("clan1"));
                L2Clan clan2 = this.getClan(rs.getInt("clan2"));
                if (clan1 != null && clan2 != null) {
                    clan1.setEnemyClan(rs.getInt("clan2"));
                    clan2.setAttackerClan(rs.getInt("clan1"));
                    continue;
                }
                LOG.warn("While restoring clan wars on of the clans [{}, {}] is null!", (Object)clan1, (Object)clan2);
            }
        }
        catch (Exception ex) {
            LOG.error("There has been an error restoring clan wars data!", ex);
        }
    }

    private void allianceCheck() {
        for (L2Clan clan : this._clans.values()) {
            int allyId = clan.getAllyId();
            if (allyId == 0 || clan.getId() == allyId || this._clans.containsKey(allyId)) continue;
            clan.setAllyId(0);
            clan.setAllyName(null);
            clan.changeAllyCrest(0, true);
            clan.updateClanInDB();
            LOG.info("Removed alliance from clan {}.", (Object)clan);
        }
    }

    public List<L2Clan> getClanAllies(int allianceId) {
        ArrayList<L2Clan> clanAllies = new ArrayList<L2Clan>();
        if (allianceId != 0) {
            for (L2Clan clan : this._clans.values()) {
                if (clan == null || clan.getAllyId() != allianceId) continue;
                clanAllies.add(clan);
            }
        }
        return clanAllies;
    }

    public void storeClanScore() {
        for (L2Clan clan : this._clans.values()) {
            clan.updateClanScoreInDB();
        }
    }

    public static ClanTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ClanTable _instance = new ClanTable();

        private SingletonHolder() {
        }
    }
}

